/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.yarn.entity;

import io.hops.metadata.yarn.entity.ContainerStatus;
import io.hops.metadata.yarn.entity.PendingEvent;
import io.hops.metadata.yarn.entity.RMNode;
import io.hops.metadata.yarn.entity.Resource;
import io.hops.metadata.yarn.entity.UpdatedContainerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMNodeComps {
    private static final Log LOG = LogFactory.getLog(RMNodeComps.class);
    private PendingEvent pendingEvent;
    private RMNode rmNode;
    private Resource resource;
    private List<UpdatedContainerInfo> updatedContainerInfo = new ArrayList<UpdatedContainerInfo>();
    private List<ContainerStatus> containersStatus = new ArrayList<ContainerStatus>();
    private Map<String, ContainerStatus> containerStatusMap = new HashMap<String, ContainerStatus>();
    private int set = 0;

    public RMNodeComps() {
    }

    public RMNodeComps(RMNode hopRMNode, Resource hopResource, PendingEvent hopPendingEvent, List<UpdatedContainerInfo> hopUpdatedContainerInfo, List<ContainerStatus> hopContainersStatus) {
        this.rmNode = hopRMNode;
        this.resource = hopResource;
        this.pendingEvent = hopPendingEvent;
        this.updatedContainerInfo = hopUpdatedContainerInfo;
        this.containersStatus = hopContainersStatus;
    }

    public PendingEvent getPendingEvent() {
        return this.pendingEvent;
    }

    public Resource getHopResource() {
        return this.resource;
    }

    public List<UpdatedContainerInfo> getHopUpdatedContainerInfo() {
        return this.updatedContainerInfo;
    }

    public Map<String, ContainerStatus> getHopContainersStatusMap() {
        if (this.containerStatusMap.size() < this.containersStatus.size()) {
            for (ContainerStatus status : this.containersStatus) {
                this.containerStatusMap.put(status.getContainerid(), status);
            }
        }
        return this.containerStatusMap;
    }

    public List<ContainerStatus> getHopContainersStatus() {
        return this.containersStatus;
    }

    public RMNode getHopRMNode() {
        return this.rmNode;
    }

    public String getRMNodeId() {
        return this.pendingEvent.getId().getNodeId();
    }

    public void setPendingEvent(PendingEvent hopPendingEvent) {
        this.pendingEvent = hopPendingEvent;
        ++this.set;
    }

    public void setRMNode(RMNode hopRMNode) {
        this.rmNode = hopRMNode;
        ++this.set;
    }

    public void setResource(Resource hopResource) {
        this.resource = hopResource;
        ++this.set;
    }

    public void addUpdatedContainerInfo(UpdatedContainerInfo updatedContainerInfo) {
        this.updatedContainerInfo.add(updatedContainerInfo);
        ++this.set;
    }

    public void addContainersStatus(ContainerStatus containersStatus) {
        this.containersStatus.add(containersStatus);
        ++this.set;
    }

    public boolean isComplet() {
        return this.pendingEvent != null && this.pendingEvent.getContains() == this.set;
    }
}

