/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

public class MetadataLogEntry {
    private final long datasetId;
    private final long inodeId;
    private final long inodePartitionId;
    private final long inodeParentId;
    private final String inodeName;
    private int logicalTime;
    private final Operation operation;

    public MetadataLogEntry(long datasetId, long inodeId, long inodePartitionId, long inodeParentId, String inodeName, int logicalTime, Operation operation) {
        this.datasetId = datasetId;
        this.inodeId = inodeId;
        this.inodePartitionId = inodePartitionId;
        this.inodeParentId = inodeParentId;
        this.inodeName = inodeName;
        this.logicalTime = logicalTime;
        this.operation = operation;
    }

    public long getDatasetId() {
        return this.datasetId;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public int getLogicalTime() {
        return this.logicalTime;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public short getOperationOrdinal() {
        return (short)this.operation.ordinal();
    }

    public long getInodePartitionId() {
        return this.inodePartitionId;
    }

    public long getInodeParentId() {
        return this.inodeParentId;
    }

    public String getInodeName() {
        return this.inodeName;
    }

    public String toString() {
        return "MetadataLogEntry{datasetId=" + this.datasetId + ", inodeId=" + this.inodeId + ", inodePartitionId=" + this.inodePartitionId + ", inodeParentId=" + this.inodeParentId + ", inodeName='" + this.inodeName + '\'' + ", logicalTime=" + this.logicalTime + ", operation=" + (Object)((Object)this.operation) + '}';
    }

    public static enum Operation {
        ADD,
        DELETE,
        UPDATE,
        RENAME,
        CHANGEDATASET;

    }
}

