/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.ReplicaBase;
import java.util.Comparator;

public class Replica
extends ReplicaBase {
    private int bucketId;

    public int getBucketId() {
        return this.bucketId;
    }

    public Replica(int storageId, long blockId, long inodeId, int bucketId) {
        super(storageId, blockId, inodeId);
        this.bucketId = bucketId;
    }

    public static enum Order implements Comparator<Replica>
    {
        ByStorageId{

            @Override
            public int compare(Replica o1, Replica o2) {
                return Integer.valueOf(o1.getStorageId()).compareTo(o2.getStorageId());
            }
        };

    }

    public static enum Finder implements FinderType<Replica>
    {
        ByBlockIdAndINodeId,
        ByINodeId,
        ByINodeIds,
        ByBlockIdAndStorageId;


        @Override
        public Class getType() {
            return Replica.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByBlockIdAndStorageId: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

