/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import com.google.common.primitives.SignedBytes;
import io.hops.metadata.hdfs.entity.INodeBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class INode
extends INodeBase
implements Comparable<INode> {
    private long modificationTime;
    private long accessTime;
    private String clientName;
    private String clientMachine;
    private String clientNode;
    private int generationStamp;
    private String symlink;
    private boolean metaEnabled;
    private boolean isFileStoredInDB;
    private int childrenNum = 0;

    public INode() {
    }

    public INode(long id, String name, long parentId, long partitionId, boolean isDir, boolean dirWithQuota, long modificationTime, long accessTime, int userID, int groupID, short permission, boolean underConstruction, String clientName, String clientMachine, String clientNode, int generationStamp, long header, String symlink, boolean subtreeLocked, long subtreeLockOwner, boolean metaEnabled, long size, boolean isFileStoredInDB, int logicalTime, byte storagePolicy, int childrenNum, int numAces) {
        super(id, parentId, name, partitionId, isDir, userID, groupID, permission, header, dirWithQuota, underConstruction, subtreeLocked, subtreeLockOwner, size, logicalTime, storagePolicy, numAces);
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
        this.generationStamp = generationStamp;
        this.symlink = symlink;
        this.metaEnabled = metaEnabled;
        this.isFileStoredInDB = isFileStoredInDB;
        this.childrenNum = childrenNum;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public void setClientMachine(String clientMachine) {
        this.clientMachine = clientMachine;
    }

    public String getClientNode() {
        return this.clientNode;
    }

    public void setClientNode(String clientNode) {
        this.clientNode = clientNode;
    }

    public int getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStamp(int generationStamp) {
        this.generationStamp = generationStamp;
    }

    public String getSymlink() {
        return this.symlink;
    }

    public void setSymlink(String symlink) {
        this.symlink = symlink;
    }

    public boolean isMetaEnabled() {
        return this.metaEnabled;
    }

    public void setMetaEnabled(boolean metaEnabled) {
        this.metaEnabled = metaEnabled;
    }

    public boolean isFileStoredInDB() {
        return this.isFileStoredInDB;
    }

    public void setFileStoredInDB(boolean isFileStoredInDB) {
        this.isFileStoredInDB = isFileStoredInDB;
    }

    @Override
    public final int compareTo(INode other) {
        String left = this.name == null ? "" : this.name;
        String right = other.name == null ? "" : other.name;
        return SignedBytes.lexicographicalComparator().compare(left.getBytes(), right.getBytes());
    }

    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof INode)) {
            return false;
        }
        return this.name.equals(((INode)that).name) && this.id == ((INode)that).id && this.parentId == ((INode)that).parentId;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.name.getBytes());
    }

    public int getChildrenNum() {
        return this.childrenNum;
    }

    public void setChildrenNum(int childrenNum) {
        this.childrenNum = childrenNum;
    }

    public static enum Order implements Comparator<INode>
    {
        ByName{

            @Override
            public int compare(INode o1, INode o2) {
                return o1.compareTo(o2);
            }
        };


        @Override
        public abstract int compare(INode var1, INode var2);

        public Comparator acsending() {
            return this;
        }

        public Comparator descending() {
            return Collections.reverseOrder(this);
        }
    }
}

