/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Slicer {
    public static void slice(int total, int sliceSize, int nbThreads, OperationHandler op) throws Exception {
        if (total == 0) {
            return;
        }
        int numOfSlices = total <= sliceSize ? 1 : (int)Math.ceil((double)total / (double)sliceSize);
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (int slice = 0; slice < numOfSlices; ++slice) {
            int n = slice * sliceSize;
            int endIndex = Math.min((slice + 1) * sliceSize, total);
            futures.add(executor.submit(new SliceRunner(op, n, endIndex)));
        }
        for (Future future : futures) {
            future.get();
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private static class SliceRunner
    implements Callable<Object> {
        final OperationHandler op;
        final int startIndex;
        final int endIndex;

        public SliceRunner(OperationHandler op, int startIndex, int endIndex) {
            this.op = op;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        public Object call() throws Exception {
            this.op.handle(this.startIndex, this.endIndex);
            return null;
        }
    }

    public static interface OperationHandler {
        public void handle(int var1, int var2) throws Exception;
    }
}

