/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.common.entity;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.ArrayVariable;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.DoubleVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.StringVariable;
import java.util.EnumMap;

public abstract class Variable {
    public static final EnumMap<Finder, byte[]> defaultValues = new EnumMap(Finder.class);
    private final Finder type;

    public static void registerVariableDefaultValue(Finder variable, byte[] defaultValue) {
        defaultValues.put(variable, defaultValue);
    }

    public Variable(Finder type) {
        this.type = type;
    }

    public abstract void setValue(byte[] var1);

    public abstract byte[] getBytes();

    public abstract Object getValue();

    public abstract int getLength();

    public Finder getType() {
        return this.type;
    }

    public static Variable getVariable(byte varType) {
        Finder type = Finder.getFinder(varType);
        return Variable.getVariable(type);
    }

    public static Variable getVariable(Finder varType) {
        switch (varType) {
            case GenericInteger: {
                return new IntVariable(varType);
            }
            case GenericLong: {
                return new LongVariable(varType);
            }
            case GenericString: {
                return new StringVariable(varType);
            }
            case GenericByteArray: {
                return new ByteArrayVariable(varType);
            }
            case GenericArray: {
                return new ArrayVariable(varType);
            }
            case BlockID: {
                return new LongVariable(varType);
            }
            case INodeID: {
                return new LongVariable(varType);
            }
            case QuotaUpdateID: {
                return new IntVariable(varType);
            }
            case ReplicationIndex: {
                return new ArrayVariable(varType);
            }
            case StorageInfo: {
                return new ArrayVariable(varType);
            }
            case BlockTokenKeys: {
                return new ArrayVariable(varType);
            }
            case BTCurrKey: 
            case BTNextKey: 
            case BTSimpleKey: {
                return new ByteArrayVariable(varType);
            }
            case SIdCounter: {
                return new IntVariable(varType);
            }
            case HdfsLeParams: 
            case YarnLeParams: {
                return new StringVariable(varType);
            }
            case MisReplicatedFilesIndex: {
                return new LongVariable(varType);
            }
            case SafeModeReached: {
                return new LongVariable(varType);
            }
            case BrLbMaxConcurrentBRs: {
                return new LongVariable(varType);
            }
            case RMStateStoreVersion: {
                return new ByteArrayVariable(varType);
            }
            case RMStateStoreEpoch: {
                return new LongVariable(varType);
            }
            case AMRMToken: {
                return new ByteArrayVariable(varType);
            }
            case RMDTSequenceNumber: {
                return new IntVariable(varType);
            }
            case QuotaTicksCounter: {
                return new LongVariable(varType);
            }
            case Seed: {
                return new ByteArrayVariable(varType);
            }
            case CacheDirectiveID: {
                return new LongVariable(varType);
            }
            case NeedRescan: {
                return new IntVariable(varType);
            }
            case RollingUpgradeInfo: {
                return new ByteArrayVariable(varType);
            }
            case SafeModeInfo: {
                return new ArrayVariable(varType);
            }
            case GenericDouble: {
                return new DoubleVariable(varType);
            }
            case BlockTotal: 
            case BlockThreshold: 
            case BlockReplicationQueueThreshold: {
                return new IntVariable(varType);
            }
        }
        return null;
    }

    public static Variable initVariable(Finder varType, byte[] varData) {
        Variable var = Variable.getVariable(varType);
        if (var != null) {
            var.setValue(varData);
        }
        return var;
    }

    public static enum Finder implements FinderType<Variable>
    {
        BlockID,
        INodeID,
        QuotaUpdateID,
        ReplicationIndex,
        StorageInfo,
        BlockTokenKeys,
        BTCurrKey,
        BTNextKey,
        BTSimpleKey,
        SIdCounter,
        HdfsLeParams,
        YarnLeParams,
        MisReplicatedFilesIndex,
        SafeModeReached,
        BrLbMaxConcurrentBRs,
        RMStateStoreVersion,
        RMStateStoreEpoch,
        AMRMToken,
        RMDTSequenceNumber,
        QuotaTicksCounter,
        GenericInteger,
        GenericLong,
        GenericString,
        GenericByteArray,
        GenericArray,
        Seed,
        StorageMap,
        CacheDirectiveID,
        NeedRescan,
        RollingUpgradeInfo,
        SafeModeInfo,
        GenericDouble,
        BlockTotal,
        BlockThreshold,
        BlockReplicationQueueThreshold;


        public int getId() {
            return this.ordinal();
        }

        public byte[] getDefaultValue() {
            return defaultValues.get(this);
        }

        public static Finder getFinder(int varType) {
            if (varType >= Finder.values().length) {
                throw new IllegalArgumentException("Variable Type " + varType + " doesn't exist");
            }
            return Finder.values()[varType];
        }

        @Override
        public Class getType() {
            return Variable.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            return FinderType.Annotation.PrimaryKey;
        }
    }
}

