/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.yarn.entity;

import io.hops.metadata.yarn.entity.PendingEventID;

public class PendingEvent
implements Comparable<PendingEvent> {
    private PendingEventID id;
    private final Type type;
    private final Status status;
    private int contains;

    public PendingEvent(String rmnodeId, Type type, Status status, int id, int contains) {
        this.type = type;
        this.status = status;
        this.id = new PendingEventID(id, rmnodeId);
        this.contains = contains;
    }

    public PendingEvent(PendingEvent pendingEvent) {
        this.type = pendingEvent.getType();
        this.status = pendingEvent.getStatus();
        this.id = new PendingEventID(pendingEvent.getId().getEventId(), pendingEvent.getId().getNodeId());
        this.contains = pendingEvent.getContains();
    }

    public PendingEventID getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "HopPendingEvent{rmnodeId=" + this.id.getNodeId() + ", type=" + (Object)((Object)this.type) + ", status=" + (Object)((Object)this.status) + ", id=" + this.id.getEventId() + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.id.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PendingEvent other = (PendingEvent)obj;
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(PendingEvent o) {
        return this.id.compareTo(o.getId());
    }

    public int getContains() {
        return this.contains;
    }

    public void setContains(int contains) {
        this.contains = contains;
    }

    public static enum Status {
        SCHEDULER_FINISHED_PROCESSING,
        SCHEDULER_NOT_FINISHED_PROCESSING,
        NEW;

    }

    public static enum Type {
        NODE_UPDATED,
        NODE_REMOVED,
        NODE_ADDED;

    }
}

