/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.yarn.entity;

public class ContainerStatus
implements Comparable<ContainerStatus> {
    private final String containerid;
    private final String state;
    private final String diagnostics;
    private final int exitstatus;
    private final String rMNodeId;
    private final Integer uciId;
    private final int pendingEventId;

    public ContainerStatus(String containerid, String state, String diagnostics, int exitstatus, String rMNodeId) {
        this(containerid, state, diagnostics, exitstatus, rMNodeId, -1, -1);
    }

    public ContainerStatus(String containerid, String state, String diagnostics, int exitstatus, String rMNodeId, int pendingId, int uciId) {
        this.containerid = containerid;
        this.state = state;
        this.diagnostics = diagnostics.substring(0, Math.min(500, diagnostics.length()));
        this.exitstatus = exitstatus;
        this.rMNodeId = rMNodeId;
        this.pendingEventId = pendingId;
        this.uciId = uciId;
    }

    public ContainerStatus(String containerid, String rMNodeId, int uciId) {
        this.containerid = containerid;
        this.state = "";
        this.diagnostics = "";
        this.exitstatus = 0;
        this.rMNodeId = rMNodeId;
        this.pendingEventId = -1;
        this.uciId = uciId;
    }

    public int getUciId() {
        return this.uciId;
    }

    public int getPendingEventId() {
        return this.pendingEventId;
    }

    public String getContainerid() {
        return this.containerid;
    }

    public String getState() {
        return this.state;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public int getExitstatus() {
        return this.exitstatus;
    }

    public String getRMNodeId() {
        return this.rMNodeId;
    }

    public String toString() {
        return "HopContainerStatus{containerid=" + this.containerid + ", state=" + this.state + ", diagnostics=" + this.diagnostics + ", exitstatus=" + this.exitstatus + "uciId= " + this.uciId + '}';
    }

    public int hashCode() {
        return this.containerid.hashCode() + 100 * this.uciId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerStatus)) {
            return false;
        }
        return this.containerid.equals(((ContainerStatus)o).getContainerid());
    }

    @Override
    public int compareTo(ContainerStatus other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.containerid.compareTo(other.getContainerid()) != 0) {
            return this.containerid.compareTo(other.getContainerid());
        }
        return this.uciId.compareTo(other.getUciId());
    }
}

