/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class Slicer {
    public static void slice(int total, int sliceSize, int nbThreads, ExecutorService executor, OperationHandler op) throws Exception {
        if (total == 0) {
            return;
        }
        int numOfSlices = total <= sliceSize ? 1 : (int)Math.ceil((double)total / (double)sliceSize);
        Semaphore semaphore = new Semaphore(nbThreads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (int slice = 0; slice < numOfSlices; ++slice) {
            int n = slice * sliceSize;
            int endIndex = Math.min((slice + 1) * sliceSize, total);
            semaphore.acquire();
            futures.add(executor.submit(new SliceRunner(op, n, endIndex, semaphore)));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static class SliceRunner
    implements Callable<Object> {
        final OperationHandler op;
        final int startIndex;
        final int endIndex;
        final Semaphore semaphore;

        public SliceRunner(OperationHandler op, int startIndex, int endIndex, Semaphore semaphore) {
            this.op = op;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.semaphore = semaphore;
        }

        @Override
        public Object call() throws Exception {
            try {
                this.op.handle(this.startIndex, this.endIndex);
                Object var1_1 = null;
                return var1_1;
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    public static interface OperationHandler {
        public void handle(int var1, int var2) throws Exception;
    }
}

