/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.handler;

import io.hops.StorageConnector;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RequestHandler {
    private long waitTime;
    protected static Log requestHandlerLOG = LogFactory.getLog(RequestHandler.class);
    protected Object[] params = null;
    protected static int RETRY_COUNT = 5;
    protected static int BASE_WAIT_TIME = 2000;
    protected OperationType opType;
    protected static StorageConnector connector;
    protected static Random rand;

    public static void setStorageConnector(StorageConnector c) {
        connector = c;
    }

    public static void setRetryCount(int retryCount) {
        RETRY_COUNT = retryCount;
        requestHandlerLOG.info((Object)("Transaction Retry Count is: " + RETRY_COUNT));
    }

    public static void setRetryBaseWaitTime(int baseWaitTime) {
        BASE_WAIT_TIME = baseWaitTime;
        requestHandlerLOG.info((Object)("Trasaction wait time before retry is: " + BASE_WAIT_TIME));
    }

    public RequestHandler(OperationType opType) {
        this.opType = opType;
    }

    public Object handle() throws IOException {
        return this.handle(null);
    }

    public Object handle(Object info) throws IOException {
        this.waitTime = 0L;
        return this.execute(info);
    }

    protected abstract Object execute(Object var1) throws IOException;

    public abstract Object performTask() throws IOException;

    public RequestHandler setParams(Object ... params) {
        this.params = params;
        return this;
    }

    public Object[] getParams() {
        return this.params;
    }

    protected long exponentialBackoff() {
        try {
            if (this.waitTime > 0L) {
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)("TX is being retried. Waiting for " + this.waitTime + " ms before retry. TX name " + this.opType));
                }
                Thread.sleep(this.waitTime);
            }
            this.waitTime = this.waitTime == 0L ? (long)rand.nextInt(BASE_WAIT_TIME) : (this.waitTime *= 2L);
            return this.waitTime;
        }
        catch (InterruptedException ex) {
            requestHandlerLOG.warn((Object)ex);
            return 0L;
        }
    }

    protected void resetWaitTime() {
        this.waitTime = 0L;
    }

    static {
        rand = new Random(System.currentTimeMillis());
    }

    public static interface OperationType {
    }
}

