/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;

public class HashBucket {
    private int storageId;
    private int bucketId;
    private long hash;

    public HashBucket(int storageId, int bucketId, long hash) {
        this.storageId = storageId;
        this.bucketId = bucketId;
        this.hash = hash;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) throws TransactionContextException, StorageException {
        this.hash = hash;
        EntityManager.update(this);
    }

    public String toString() {
        return "HashBucket{storageId=" + this.storageId + ", bucketId=" + this.bucketId + ", hash=" + this.hash + '}';
    }

    public static class PrimaryKey {
        private int bucketId;
        private int storageId;

        public PrimaryKey(int storageId, int bucketId) {
            this.storageId = storageId;
            this.bucketId = bucketId;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public int getStorageId() {
            return this.storageId;
        }

        public boolean equals(Object o) {
            if (o instanceof PrimaryKey) {
                PrimaryKey otherPK = (PrimaryKey)o;
                return this.bucketId == otherPK.getBucketId() && this.storageId == otherPK.getStorageId();
            }
            return false;
        }

        public int hashCode() {
            return this.bucketId * this.storageId;
        }
    }

    public static enum Finder implements FinderType<HashBucket>
    {
        ByStorageIdAndBucketId,
        ByStorageId;


        @Override
        public Class getType() {
            return HashBucket.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByStorageIdAndBucketId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByStorageId: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

