/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;

public class SubTreeOperation
implements Comparable<SubTreeOperation> {
    private long nameNodeId;
    private String path;
    private Type opType;

    public SubTreeOperation(String path) {
        this.path = path;
        this.nameNodeId = -1L;
        this.opType = Type.NA;
    }

    public SubTreeOperation(String path, long nameNodeId, Type opType) {
        this.path = path;
        this.nameNodeId = nameNodeId;
        this.opType = opType;
    }

    public long getNameNodeId() {
        return this.nameNodeId;
    }

    public void setHolderId(long nameNodeId) {
        this.nameNodeId = nameNodeId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Type getOpType() {
        return this.opType;
    }

    public void setOpType(Type opType) {
        this.opType = opType;
    }

    @Override
    public int compareTo(SubTreeOperation t) {
        return this.path.compareTo(t.getPath());
    }

    public boolean equals(Object obj) {
        SubTreeOperation other = (SubTreeOperation)obj;
        return this.path.equals(other.getPath()) && this.nameNodeId == other.getNameNodeId() && this.opType == other.opType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 37 * hash + new Long(this.nameNodeId).hashCode();
        return hash;
    }

    public String toString() {
        return this.path;
    }

    public static enum Finder implements FinderType<SubTreeOperation>
    {
        ByPathPrefix;


        @Override
        public Class getType() {
            return SubTreeOperation.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByPathPrefix: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Type {
        RENAME_STO,
        DELETE_STO,
        CONTENT_SUMMARY_STO,
        QUOTA_STO,
        SET_PERMISSION_STO,
        SET_OWNER_STO,
        META_ENABLE_STO,
        NA;

    }
}

