/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import java.util.Arrays;

public class RetryCacheEntry {
    private byte[] clientId;
    private int callId;
    private byte[] payload;
    private long expirationTime;
    private byte state;

    public RetryCacheEntry(byte[] clientId, int callId) {
        this.clientId = clientId;
        this.callId = callId;
        this.payload = null;
        this.expirationTime = 0L;
        this.state = 0;
    }

    public RetryCacheEntry(byte[] clientId, int callId, byte[] payload, long expirationTime, byte state) {
        this.clientId = clientId;
        this.callId = callId;
        this.payload = payload;
        this.expirationTime = expirationTime;
        this.state = state;
    }

    public byte[] getClientId() {
        return this.clientId;
    }

    public int getCallId() {
        return this.callId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public byte getState() {
        return this.state;
    }

    public static class PrimaryKey {
        private byte[] clientId;
        private int callId;

        public PrimaryKey(byte[] clientId, int callId) {
            this.clientId = clientId;
            this.callId = callId;
        }

        public byte[] getClientId() {
            return this.clientId;
        }

        public int getCallId() {
            return this.callId;
        }

        public boolean equals(Object o) {
            if (o instanceof PrimaryKey) {
                PrimaryKey otherPK = (PrimaryKey)o;
                return this.clientId == otherPK.getClientId() && this.callId == otherPK.getCallId();
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.clientId) * this.callId;
        }
    }

    public static enum Finder implements FinderType<RetryCacheEntry>
    {
        ByClientIdAndCallId;


        @Override
        public Class getType() {
            return RetryCacheEntry.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByClientIdAndCallId: {
                    return FinderType.Annotation.PrimaryKey;
                }
            }
            throw new IllegalStateException();
        }
    }
}

