/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.LockUpgradeException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import io.hops.transaction.lock.VariablesLock;
import java.util.Collection;

public class VariableContext
extends BaseEntityContext<Variable.Finder, Variable> {
    private final VariableDataAccess<Variable, Variable.Finder> dataAccess;

    public VariableContext(VariableDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(Variable hopVariable) throws TransactionContextException {
        super.update(hopVariable);
        this.log("updated-" + hopVariable.getType().toString(), "value", hopVariable.toString());
    }

    @Override
    public Variable find(FinderType<Variable> finder, Object ... params) throws TransactionContextException, StorageException {
        Variable.Finder varType = (Variable.Finder)finder;
        Variable var = null;
        if (this.contains(varType)) {
            var = (Variable)this.get(varType);
            this.hit((FinderType)varType, var, new Object[0]);
        } else {
            this.aboutToAccessStorage(finder, params);
            var = this.dataAccess.getVariable(varType);
            this.gotFromDB(varType, var);
            this.miss((FinderType)varType, var, new Object[0]);
        }
        return var;
    }

    @Override
    public void prepare(TransactionLocks lks) throws TransactionContextException, StorageException {
        Collection<Variable> added = this.getAdded();
        Collection<Variable> modified = this.getModified();
        if (lks.containsLock(Lock.Type.Variable)) {
            VariablesLock hlk = (VariablesLock)lks.getLock(Lock.Type.Variable);
            this.checkLockUpgrade(hlk, added);
            this.checkLockUpgrade(hlk, modified);
        }
        if (!this.getRemoved().isEmpty()) {
            throw new IllegalStateException("removed variables is not empty even though VariableContext doesn't support remove");
        }
        this.dataAccess.prepare(added, modified, null);
    }

    private void checkLockUpgrade(VariablesLock hlk, Collection<Variable> variables) throws LockUpgradeException {
        for (Variable var : variables) {
            if (hlk.getVariableLockType(var.getType()).equals((Object)TransactionLockTypes.LockType.WRITE)) continue;
            throw new LockUpgradeException(var.getType().toString());
        }
    }

    @Override
    Variable.Finder getKey(Variable hopVariable) {
        return hopVariable.getType();
    }
}

