/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import com.google.common.base.Charsets;
import io.hops.metadata.common.FinderType;
import java.util.Objects;

public final class StoredXAttr {
    public static final int MAX_NUM_XATTRS_PER_INODE = 255;
    public static final int MAX_XATTR_NAME_SIZE = 255;
    public static final int MAX_XATTR_VALUE_SIZE = 13730;
    private final PrimaryKey primaryKey;
    private final String value;

    public StoredXAttr(long inodeId, byte namespace, String name, String value) {
        this.primaryKey = new PrimaryKey(inodeId, namespace, name);
        this.value = value;
    }

    public StoredXAttr(long inodeId, byte namespace, String name, byte[] value) {
        this(inodeId, namespace, name, StoredXAttr.getXAttrString(value));
    }

    public long getInodeId() {
        return this.primaryKey.getInodeId();
    }

    public byte getNamespace() {
        return this.primaryKey.getNamespace();
    }

    public String getName() {
        return this.primaryKey.getName();
    }

    public String getValue() {
        return this.value;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public byte[] getValueBytes() {
        return StoredXAttr.getXAttrBytes(this.value);
    }

    public static final byte[] getXAttrBytes(String val) {
        if (val == null) {
            return null;
        }
        return val.getBytes(Charsets.UTF_8);
    }

    public static final String getXAttrString(byte[] val) {
        if (val == null) {
            return null;
        }
        return new String(val, Charsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredXAttr)) {
            return false;
        }
        StoredXAttr that = (StoredXAttr)o;
        return this.primaryKey.equals(that.primaryKey) && this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.primaryKey, this.getValue());
    }

    public String toString() {
        return "StoredXAttr{primaryKey=" + this.primaryKey + ", value='" + this.value + '\'' + '}';
    }

    public static final class PrimaryKey {
        private final long inodeId;
        private final byte namespace;
        private final String name;

        public PrimaryKey(long inodeId, byte namespace, String name) {
            this.inodeId = inodeId;
            this.namespace = namespace;
            this.name = name;
        }

        public long getInodeId() {
            return this.inodeId;
        }

        public byte getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimaryKey)) {
                return false;
            }
            PrimaryKey that = (PrimaryKey)o;
            return this.inodeId == that.inodeId && this.namespace == that.namespace && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.inodeId, this.namespace, this.name);
        }

        public String toString() {
            return "PrimaryKey{inodeId=" + this.inodeId + ", namespace=" + this.namespace + ", name='" + this.name + '\'' + '}';
        }
    }

    public static enum Finder implements FinderType<StoredXAttr>
    {
        ByPrimaryKey,
        ByPrimaryKeyBatch,
        ByInodeId;


        @Override
        public Class getType() {
            return StoredXAttr.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByPrimaryKey: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByPrimaryKeyBatch: {
                    return FinderType.Annotation.Batched;
                }
                case ByInodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

