/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.EntityContextStat;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransactionContext {
    private static String UNKNOWN_TYPE = "Unknown type:";
    private boolean activeTxExpected = false;
    private Map<Class, EntityContext> typeContextMap;
    private Set<EntityContext> contexts = new HashSet<EntityContext>();
    private StorageConnector connector;

    public TransactionContext(StorageConnector connector, Map<Class, EntityContext> entityContext) {
        this.typeContextMap = entityContext;
        for (EntityContext context : entityContext.values()) {
            if (this.contexts.contains(context)) continue;
            this.contexts.add(context);
        }
        this.connector = connector;
    }

    private void resetContext() throws TransactionContextException {
        this.activeTxExpected = false;
        this.clearContext();
        EntityContext.setLockMode(null);
    }

    public void clearContext() throws TransactionContextException {
        for (EntityContext context : this.contexts) {
            context.clear();
        }
    }

    public void begin() throws StorageException {
        this.activeTxExpected = true;
        this.connector.beginTransaction();
    }

    public void preventStorageCall(boolean val) {
        for (EntityContext context : this.contexts) {
            context.preventStorageCall(val);
        }
    }

    public void commit(TransactionLocks tlm) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        for (EntityContext context : this.contexts) {
            context.prepare(tlm);
        }
        this.connector.commit();
        this.resetContext();
    }

    public void rollback() throws StorageException, TransactionContextException {
        this.resetContext();
        this.connector.rollback();
    }

    public <T> void update(T obj) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        if (!this.typeContextMap.containsKey(obj.getClass())) {
            throw new RuntimeException(UNKNOWN_TYPE + obj.getClass());
        }
        this.typeContextMap.get(obj.getClass()).update(obj);
    }

    public <T> void add(T obj) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        if (!this.typeContextMap.containsKey(obj.getClass())) {
            throw new RuntimeException(UNKNOWN_TYPE + obj.getClass());
        }
        this.typeContextMap.get(obj.getClass()).add(obj);
    }

    public <T> void remove(T obj) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        if (!this.typeContextMap.containsKey(obj.getClass())) {
            throw new RuntimeException(UNKNOWN_TYPE + obj.getClass());
        }
        this.typeContextMap.get(obj.getClass()).remove(obj);
    }

    public void removeAll(Class type) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        if (!this.typeContextMap.containsKey(type)) {
            throw new RuntimeException(UNKNOWN_TYPE + type);
        }
        this.typeContextMap.get(type).removeAll();
    }

    public <T> T find(FinderType<T> finder, Object ... params) throws TransactionContextException, StorageException {
        this.aboutToPerform();
        if (this.typeContextMap.containsKey(finder.getType())) {
            return this.typeContextMap.get(finder.getType()).find(finder, params);
        }
        throw new RuntimeException(UNKNOWN_TYPE + finder.getType());
    }

    public <T> Collection<T> findList(FinderType<T> finder, Object ... params) throws TransactionContextException, StorageException {
        this.aboutToPerform();
        if (this.typeContextMap.containsKey(finder.getType())) {
            return this.typeContextMap.get(finder.getType()).findList(finder, params);
        }
        throw new RuntimeException(UNKNOWN_TYPE + finder.getType());
    }

    public int count(CounterType counter, Object ... params) throws StorageException, TransactionContextException {
        this.aboutToPerform();
        if (this.typeContextMap.containsKey(counter.getType())) {
            return this.typeContextMap.get(counter.getType()).count(counter, params);
        }
        throw new RuntimeException(UNKNOWN_TYPE + counter.getType());
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        for (EntityContext context : this.contexts) {
            context.snapshotMaintenance(cmds, params);
        }
    }

    private void aboutToPerform() throws StorageException {
        if (!this.activeTxExpected) {
            throw new RuntimeException("Transaction is not begun.");
        }
    }

    public Collection<EntityContextStat> collectSnapshotStat() throws TransactionContextException {
        ArrayList<EntityContextStat> stats = new ArrayList<EntityContextStat>();
        for (EntityContext context : this.contexts) {
            EntityContextStat stat = context.collectSnapshotStat();
            if (stat == null) continue;
            stats.add(stat);
        }
        return stats;
    }
}

