/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.hdfs.entity.MetadataLogEntry;

public final class XAttrMetadataLogEntry
extends MetadataLogEntry {
    private final Operation operation;

    public XAttrMetadataLogEntry(MetadataLogEntry entry) {
        this(entry.getDatasetId(), entry.getInodeId(), entry.getLogicalTime(), (byte)entry.getPk2(), entry.getPk3(), Operation.valueOf(entry.getOperationId()));
    }

    public XAttrMetadataLogEntry(long datasetId, long inodeId, int logicalTime, byte namespace, String name, Operation operation) {
        super(datasetId, inodeId, logicalTime, inodeId, namespace, name, operation.getId());
        this.operation = operation;
    }

    public XAttrMetadataLogEntry(long datasetId, long inodeId, int logicalTime) {
        super(datasetId, inodeId, logicalTime, -1L, -1L, "-1", Operation.AddAll.getId());
        this.operation = Operation.AddAll;
    }

    public byte getNamespace() {
        return (byte)this.getPk2();
    }

    public String getName() {
        return this.getPk3();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static boolean isValidOperation(short operationId) {
        return Operation.valueOf(operationId) != null;
    }

    public static enum Operation implements MetadataLogEntry.OperationBase
    {
        Add(10),
        AddAll(11),
        Update(12),
        Delete(13);

        private final short opId;

        private Operation(short opId) {
            this.opId = opId;
        }

        @Override
        public short getId() {
            return this.opId;
        }

        static Operation valueOf(short id) {
            for (Operation op : Operation.values()) {
                if (op.getId() != id) continue;
                return op;
            }
            throw new IllegalArgumentException("invalid operatin id " + id);
        }
    }
}

