/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;

public class LeasePath
implements Comparable<LeasePath> {
    private int holderId;
    private String path;
    private long lastBlockId;
    private long penultimateBlockId;

    public LeasePath(String path, int holderId) {
        this.holderId = holderId;
        this.path = path;
        this.lastBlockId = -1L;
        this.penultimateBlockId = -1L;
    }

    public LeasePath(String path, int holderId, long lastBlockId, long penultimateBlockId) {
        this(path, holderId);
        this.lastBlockId = lastBlockId;
        this.penultimateBlockId = penultimateBlockId;
    }

    public int getHolderId() {
        return this.holderId;
    }

    public void setHolderId(int holderId) {
        this.holderId = holderId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getLastBlockId() {
        return this.lastBlockId;
    }

    public void setLastBlockId(long lastBlockId) {
        this.lastBlockId = lastBlockId;
    }

    public long getPenultimateBlockId() {
        return this.penultimateBlockId;
    }

    public void setPenultimateBlockId(long penultimateBlockId) {
        this.penultimateBlockId = penultimateBlockId;
    }

    @Override
    public int compareTo(LeasePath t) {
        return this.path.compareTo(t.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LeasePath)) {
            return false;
        }
        LeasePath other = (LeasePath)obj;
        return this.path.equals(other.getPath()) && this.holderId == other.getHolderId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.path;
    }

    public static enum Finder implements FinderType<LeasePath>
    {
        ByHolderId,
        ByPath,
        ByPrefix;


        @Override
        public Class getType() {
            return LeasePath.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByHolderId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByPath: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByPrefix: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

