/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import java.util.Date;

public class SubTreeOperation
implements Comparable<SubTreeOperation> {
    private long nameNodeId;
    private String path;
    private Type opType;
    private long asyncLockRecoveryTime = 0L;
    private long startTime;
    private String user;
    private long inodeID;

    public SubTreeOperation(String path, long inodeID, long nameNodeId, Type opType, long startTime, String user) {
        this(path, inodeID, nameNodeId, opType, startTime, user, 0L);
    }

    public SubTreeOperation(String path, long inodeID, long nameNodeId, Type opType, long startTime, String user, long asyncLockRecovery) {
        this.path = path;
        this.nameNodeId = nameNodeId;
        this.opType = opType;
        this.startTime = startTime;
        this.user = user;
        this.asyncLockRecoveryTime = asyncLockRecovery;
        this.inodeID = inodeID;
    }

    public long getNameNodeId() {
        return this.nameNodeId;
    }

    public void setHolderId(long nameNodeId) {
        this.nameNodeId = nameNodeId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Type getOpType() {
        return this.opType;
    }

    public void setOpType(Type opType) {
        this.opType = opType;
    }

    public long getAsyncLockRecoveryTime() {
        return this.asyncLockRecoveryTime;
    }

    public void setAsyncLockRecoveryTime(long asyncLockRecoveryTime) {
        this.asyncLockRecoveryTime = asyncLockRecoveryTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public long getInodeID() {
        return this.inodeID;
    }

    public void setInodeID(long inodeID) {
        this.inodeID = inodeID;
    }

    @Override
    public int compareTo(SubTreeOperation t) {
        return this.path.compareTo(t.getPath());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubTreeOperation)) {
            return false;
        }
        SubTreeOperation other = (SubTreeOperation)obj;
        return this.path.equals(other.getPath()) && this.nameNodeId == other.getNameNodeId() && this.opType == other.opType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 37 * hash + new Long(this.nameNodeId).hashCode();
        hash = 37 * hash + this.opType.hashCode();
        return hash;
    }

    public String toString() {
        return "Path: " + this.path + ", INodeID: " + this.inodeID + ", NN ID: " + this.nameNodeId + ", Operation: " + (Object)((Object)this.opType) + ", User: " + this.user + ", Start Time:" + new Date(this.startTime).toString() + (this.asyncLockRecoveryTime > 0L ? ", Recovery Start Time " + new Date(this.asyncLockRecoveryTime).toString() : "");
    }

    public static enum Finder implements FinderType<SubTreeOperation>
    {
        ByPathPrefix,
        ByPath;


        @Override
        public Class getType() {
            return SubTreeOperation.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByPath: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByPathPrefix: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Type {
        RENAME_STO,
        DELETE_STO,
        CONTENT_SUMMARY_STO,
        QUOTA_STO,
        SET_PERMISSION_STO,
        SET_OWNER_STO,
        META_ENABLE_STO,
        NA;

    }
}

