/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import java.util.Comparator;

public class Ace {
    private long inodeId;
    private int index;
    private String subject;
    private AceType type;
    private boolean isDefault;
    private int permission;

    public Ace(long inodeId, int index) {
        this.inodeId = inodeId;
        this.index = index;
    }

    public Ace(long inodeId, int index, String subject, AceType type, boolean isDefault, int permission) {
        this.inodeId = inodeId;
        this.index = index;
        this.subject = subject;
        this.isDefault = isDefault;
        this.permission = permission;
        this.type = type;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(long inodeId) {
        this.inodeId = inodeId;
    }

    public String getSubject() {
        return this.subject;
    }

    public AceType getType() {
        return this.type;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public int getPermission() {
        return this.permission;
    }

    public int getIndex() {
        return this.index;
    }

    public Ace copy() {
        return new Ace(this.inodeId, this.index, this.subject, this.type, this.isDefault, this.permission);
    }

    public static class PrimaryKey {
        public final long inodeId;
        public final int index;

        public PrimaryKey(long inodeId, int index) {
            this.index = index;
            this.inodeId = inodeId;
        }

        public int hashCode() {
            return this.index * Long.hashCode(this.inodeId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PrimaryKey) {
                PrimaryKey other = (PrimaryKey)obj;
                return this.inodeId == other.inodeId && this.index == other.index;
            }
            return false;
        }
    }

    public static enum Finder implements FinderType<Ace>
    {
        ByInodeIdAndIndices;


        @Override
        public Class getType() {
            return Ace.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByInodeIdAndIndices: {
                    return FinderType.Annotation.PrimaryKey;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Order implements Comparator<Ace>
    {
        ByIndexAscending{

            @Override
            public int compare(Ace ace, Ace t1) {
                return ace.getIndex() - t1.getIndex();
            }
        };

    }

    public static enum AceType {
        USER(0),
        GROUP(1),
        MASK(2),
        OTHER(3);

        int value;

        private AceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AceType valueOf(int value) {
            switch (value) {
                case 0: {
                    return USER;
                }
                case 1: {
                    return GROUP;
                }
                case 2: {
                    return MASK;
                }
                case 3: {
                    return OTHER;
                }
            }
            throw new RuntimeException("Incorrect value " + value + ", should be 0, 1, 2 or 3;");
        }
    }
}

