/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.common.entity;

import io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DoubleVariable
extends Variable {
    private Double value = new Double(0.0);

    public DoubleVariable(Variable.Finder type, double value) {
        this(type);
        this.value = value;
    }

    public DoubleVariable(Variable.Finder type) {
        super(type);
    }

    public DoubleVariable(double value) {
        this(Variable.Finder.GenericDouble, value);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        if (val == null || val.length != this.getLength()) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(val);
        this.value = buf.getDouble();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putDouble(this.value);
        return buf.array();
    }

    @Override
    public int getLength() {
        return 8;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleVariable that = (DoubleVariable)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

