/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.hdfs.entity.MetadataLogEntry;

public final class INodeMetadataLogEntry
extends MetadataLogEntry {
    private final Operation operation;

    public INodeMetadataLogEntry(MetadataLogEntry entry) {
        super(entry);
        this.operation = Operation.valueOf(entry.getOperationId());
    }

    public INodeMetadataLogEntry(long datasetId, long inodeId, long inodePartitionId, long inodeParentId, String inodeName, int logicalTime, Operation operation) {
        super(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, operation.getId());
        this.operation = operation;
    }

    public long getPartitionId() {
        return this.getInodePartitionId();
    }

    public long getParentId() {
        return this.getInodeParentId();
    }

    public String getName() {
        return this.getInodeName();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static boolean isValidOperation(short operationId) {
        try {
            Operation.valueOf(operationId);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static enum Operation implements MetadataLogEntry.OperationBase
    {
        Add(0),
        Delete(1),
        Update(2),
        Rename(3),
        ChangeDataset(4);

        private final short opId;

        private Operation(short opId) {
            this.opId = opId;
        }

        @Override
        public short getId() {
            return this.opId;
        }

        static Operation valueOf(short id) {
            for (Operation op : Operation.values()) {
                if (op.getId() != id) continue;
                return op;
            }
            throw new IllegalArgumentException("invalid operatin id " + id);
        }
    }
}

