/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.exception.UnknownMetadataOperationType;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.XAttrMetadataLogEntry;

public class MetadataLogEntry {
    private final long datasetId;
    private final long inodeId;
    private final long pk1;
    private final long pk2;
    private final String pk3;
    private int logicalTime;
    private final short operation;
    private final long inodePartitionId;
    private final long inodeParentId;
    private final String inodeName;

    protected MetadataLogEntry(MetadataLogEntry entry) {
        this(entry.getDatasetId(), entry.getInodeId(), entry.getLogicalTime(), entry.getInodePartitionId(), entry.getInodeParentId(), entry.getInodeName(), entry.getPk1(), entry.getPk2(), entry.getPk3(), entry.getOperationId());
    }

    protected MetadataLogEntry(long datasetId, long inodeId, int logicalTime, long inodePartitionId, long inodeParentId, String inodeName, short operation) {
        this(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, -1L, -1L, "-1", operation);
    }

    protected MetadataLogEntry(long datasetId, long inodeId, int logicalTime, long inodePartitionId, long inodeParentId, String inodeName, long pk1, long pk2, String pk3, short operation) {
        this.datasetId = datasetId;
        this.inodeId = inodeId;
        this.logicalTime = logicalTime;
        this.inodePartitionId = inodePartitionId;
        this.inodeParentId = inodeParentId;
        this.inodeName = inodeName;
        this.pk1 = pk1;
        this.pk2 = pk2;
        this.pk3 = pk3;
        this.operation = operation;
    }

    public long getDatasetId() {
        return this.datasetId;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public int getLogicalTime() {
        return this.logicalTime;
    }

    public short getOperationId() {
        return this.operation;
    }

    public long getPk1() {
        return this.pk1;
    }

    public long getPk2() {
        return this.pk2;
    }

    public String getPk3() {
        return this.pk3;
    }

    public long getInodePartitionId() {
        return this.inodePartitionId;
    }

    public long getInodeParentId() {
        return this.inodeParentId;
    }

    public String getInodeName() {
        return this.inodeName;
    }

    public static MetadataLogEntry newEntry(long datasetId, long inodeId, int logicalTime, long inodePartitionId, long inodeParentId, String inodeName, long pk1, long pk2, String pk3, short operationId) throws UnknownMetadataOperationType {
        if (INodeMetadataLogEntry.isValidOperation(operationId)) {
            return new INodeMetadataLogEntry(new MetadataLogEntry(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, pk1, pk2, pk3, operationId));
        }
        if (XAttrMetadataLogEntry.isValidOperation(operationId)) {
            return new XAttrMetadataLogEntry(new MetadataLogEntry(datasetId, inodeId, logicalTime, inodePartitionId, inodeParentId, inodeName, pk1, pk2, pk3, operationId));
        }
        throw new UnknownMetadataOperationType(operationId);
    }

    public String toString() {
        return "MetadataLogEntry{datasetId=" + this.datasetId + ", inodeId=" + this.inodeId + ", pk1=" + this.pk1 + ", pk2=" + this.pk2 + ", pk3='" + this.pk3 + '\'' + ", logicalTime=" + this.logicalTime + ", operation=" + this.operation + '}';
    }

    public static interface OperationBase {
        public short getId();
    }
}

