/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.EntityContextStat;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

abstract class BaseEntityContext<Key, Entity>
extends EntityContext<Entity> {
    private static boolean statsEnabled = false;
    private final Map<Key, ContextEntity> contextEntities = new HashMap<Key, ContextEntity>();
    private EntityContextStat contextStat;

    BaseEntityContext() {
    }

    public static void enableStats() {
        statsEnabled = true;
    }

    public static void disableStats() {
        statsEnabled = false;
    }

    @Override
    public void add(Entity entity) throws TransactionContextException {
        this.update(entity);
    }

    @Override
    public void update(Entity entity) throws TransactionContextException {
        Key entityKey = this.getKey(entity);
        ContextEntity contextEntity = this.contextEntities.get(entityKey);
        if (contextEntity == null) {
            contextEntity = new ContextEntity(entity, State.ADDED);
            this.contextEntities.put(entityKey, contextEntity);
        } else {
            contextEntity.update(entity, State.MODIFIED);
        }
    }

    @Override
    public void remove(Entity entity) throws TransactionContextException {
        Key entityKey = this.getKey(entity);
        ContextEntity contextEntity = this.contextEntities.get(entityKey);
        if (contextEntity == null || contextEntity.getEntity() == null) {
            throw new TransactionContextException("Unattached Entity passed to be removed " + entity);
        }
        contextEntity.update(entity, State.REMOVED);
    }

    @Override
    public void clear() throws TransactionContextException {
        this.storageCallPrevented = false;
        this.contextEntities.clear();
    }

    @Override
    public int count(CounterType<Entity> counter, Object ... params) throws TransactionContextException, StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Entity find(FinderType<Entity> finder, Object ... params) throws TransactionContextException, StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<Entity> findList(FinderType<Entity> finder, Object ... params) throws TransactionContextException, StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAll() throws TransactionContextException, StorageException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final EntityContextStat collectSnapshotStat() throws TransactionContextException {
        return this.resetContextStat();
    }

    @Override
    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
    }

    final Collection<Entity> getRemoved() {
        Collection entities = Maps.transformValues(this.contextEntities, (Function)new Function<ContextEntity, Entity>(){

            public Entity apply(ContextEntity input) {
                if (input.getState() == State.REMOVED && input.firstState == State.DBREAD) {
                    return input.getEntity();
                }
                return null;
            }
        }).values();
        return Collections2.filter(entities, (Predicate)Predicates.notNull());
    }

    final Collection<Entity> getAdded() {
        return this.filterValuesOnState(State.ADDED);
    }

    final Collection<Entity> getModified() {
        return this.filterValuesOnState(State.MODIFIED);
    }

    final Collection<Entity> filterValuesOnState(State state) {
        return this.filterValues(state, false);
    }

    final Collection<Entity> filterValuesNotOnState(State state) {
        return this.filterValues(state, true);
    }

    private Collection<Entity> filterValues(final State state, final boolean not) {
        Collection entities = Maps.transformValues(this.contextEntities, (Function)new Function<ContextEntity, Entity>(){

            public Entity apply(ContextEntity input) {
                if (not ? input.getState() != state : input.getState() == state) {
                    return input.getEntity();
                }
                return null;
            }
        }).values();
        return Collections2.filter(entities, (Predicate)Predicates.notNull());
    }

    abstract Key getKey(Entity var1);

    final boolean isNewlyAdded(Key key) {
        return this.containsFirst(key, State.ADDED);
    }

    final boolean isReadFromDB(Key key) {
        return this.containsFirst(key, State.DBREAD);
    }

    final boolean isRemoved(Key key) {
        return this.contains(key, State.REMOVED);
    }

    final boolean isModified(Key key) {
        return this.contains(key, State.MODIFIED);
    }

    private boolean containsFirst(Key key, State state) {
        ContextEntity ce = this.contextEntities.get(key);
        if (ce != null) {
            return ce.firstState == state;
        }
        return false;
    }

    private boolean contains(Key key, State state) {
        ContextEntity ce = this.contextEntities.get(key);
        if (ce != null) {
            return ce.getState() == state;
        }
        return false;
    }

    final boolean contains(Key key) {
        return this.contextEntities.containsKey(key);
    }

    final boolean contains(Predicate<ContextEntity> pred) {
        return this.get(pred).size() != 0;
    }

    final Entity get(Key key) {
        ContextEntity ce = this.contextEntities.get(key);
        if (ce != null && ce.getState() != State.REMOVED) {
            return ce.getEntity();
        }
        return null;
    }

    final Collection<Entity> get(Predicate<ContextEntity> pred) {
        Map filtered = Maps.filterValues(this.contextEntities, pred);
        Collection transformed = Maps.transformValues((Map)filtered, (Function)new Function<ContextEntity, Entity>(){

            public Entity apply(ContextEntity input) {
                return input.getEntity();
            }
        }).values();
        return Collections2.filter(transformed, (Predicate)Predicates.notNull());
    }

    final Collection<Entity> getAll() {
        Collection tr = Collections2.transform(this.contextEntities.values(), (Function)new Function<ContextEntity, Entity>(){

            public Entity apply(ContextEntity input) {
                return input.getEntity();
            }
        });
        return Collections2.filter((Collection)tr, (Predicate)Predicates.notNull());
    }

    final ContextEntity max(Comparator<ContextEntity> contextEntityComparator) {
        return Collections.max(this.contextEntities.values(), contextEntityComparator);
    }

    void gotFromDB(Collection<Entity> entityList) {
        if (entityList != null) {
            for (Entity entity : entityList) {
                this.gotFromDB(entity);
            }
        }
    }

    final void gotFromDB(Entity entity) {
        if (entity != null) {
            this.gotFromDB(this.getKey(entity), entity);
        }
    }

    void gotFromDB(Key entityKey, Entity entity) {
        ContextEntity contextEntity = this.contextEntities.get(entityKey);
        if (contextEntity == null) {
            contextEntity = new ContextEntity(entity, State.DBREAD);
            this.contextEntities.put(entityKey, contextEntity);
        } else {
            contextEntity.update(entity, State.DBREAD);
        }
    }

    final int size() {
        return this.contextEntities.size();
    }

    protected void hit(FinderType finder, Entity res, Object ... params) {
        this.hit(finder, res == null ? 0 : 1, params);
    }

    protected void hit(FinderType finder, Collection<Entity> res, Object ... params) {
        this.hit(finder, res == null ? 0 : res.size(), params);
    }

    protected void miss(FinderType finder, Entity res, Object ... params) {
        this.miss(finder, res == null ? 0 : 1, params);
    }

    protected void miss(FinderType finder, Collection<Entity> res, Object ... params) {
        this.miss(finder, res == null ? 0 : res.size(), params);
    }

    protected void missUpgrade(FinderType finder, Entity res, Object ... params) {
        this.missUpgrade(finder, res == null ? 0 : 1, params);
    }

    protected void missUpgrade(FinderType finder, Collection<Entity> res, Object ... params) {
        this.missUpgrade(finder, res == null ? 0 : res.size(), params);
    }

    private void hit(FinderType finder, int count, Object ... params) {
        BaseEntityContext.log(finder, EntityContext.CacheHitState.HIT, params);
        this.hit(finder, count);
    }

    private void miss(FinderType finder, int count, Object ... params) {
        this.miss(finder, EntityContext.CacheHitState.LOSS, count, params);
    }

    private void missUpgrade(FinderType finder, int count, Object ... params) {
        this.miss(finder, EntityContext.CacheHitState.LOSS_LOCK_UPGRADE, count, params);
    }

    private void miss(FinderType finder, EntityContext.CacheHitState state, int count, Object ... params) {
        BaseEntityContext.log(finder, state, params);
        this.miss(finder, count);
    }

    private void hit(FinderType finderType, int count) {
        if (statsEnabled) {
            this.getContextStat().hit(finderType, count);
        }
    }

    private void miss(FinderType finderType, int count) {
        if (statsEnabled) {
            this.getContextStat().miss(finderType, count);
        }
    }

    private EntityContextStat getContextStat() {
        if (this.contextStat == null) {
            this.contextStat = new EntityContextStat(this.getClass().getSimpleName());
        }
        return this.contextStat;
    }

    private EntityContextStat resetContextStat() {
        if (statsEnabled) {
            EntityContextStat stat = this.getContextStat();
            stat.commited(this.getAdded().size(), this.getModified().size(), this.getRemoved().size());
            this.contextStat = null;
            if (stat.isEmpty()) {
                stat = null;
            }
            return stat;
        }
        return null;
    }

    class ContextEntity {
        private State firstState;
        private State state;
        private Entity entity;

        ContextEntity(Entity entity) {
            this.entity = entity;
        }

        ContextEntity(Entity entity, State state) {
            this(entity);
            this.firstState = state;
            this.state = state;
        }

        void update(Entity entity, State state) {
            this.entity = entity;
            this.state = state;
        }

        State getState() {
            return this.state;
        }

        Entity getEntity() {
            return this.entity;
        }

        public String toString() {
            return "ContextEntity{state=" + (Object)((Object)this.state) + ", entity=" + this.entity + '}';
        }
    }

    static enum State {
        DBREAD,
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

