/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;

public class BlockChecksum {
    private long inodeId;
    private int blockIndex;
    private long checksum;

    public BlockChecksum() {
    }

    public BlockChecksum(long inodeId, int blockIndex, long checksum) {
        this.inodeId = inodeId;
        this.blockIndex = blockIndex;
        this.checksum = checksum;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public void setInodeId(int inodeId) {
        this.inodeId = inodeId;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public void setBlockIndex(int blockIndex) {
        this.blockIndex = blockIndex;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockChecksum that = (BlockChecksum)o;
        if (this.blockIndex != that.blockIndex) {
            return false;
        }
        if (this.checksum != that.checksum) {
            return false;
        }
        return this.inodeId == that.inodeId;
    }

    public int hashCode() {
        int result = Long.hashCode(this.inodeId);
        result = 31 * result + this.blockIndex;
        result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
        return result;
    }

    public String toString() {
        return "BlockChecksum{inodeId=" + this.inodeId + ", blockIndex=" + this.blockIndex + ", checksum=" + this.checksum + '}';
    }

    public static enum Finder implements FinderType<BlockChecksum>
    {
        ByKeyTuple,
        ByInodeId;


        @Override
        public Class getType() {
            return BlockChecksum.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByKeyTuple: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByInodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

