/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.handler;

import io.hops.exception.LockUpgradeException;
import io.hops.exception.OutOfDBExtentsException;
import io.hops.exception.StorageException;
import io.hops.exception.TransientDeadLockException;
import io.hops.exception.TransientStorageException;
import io.hops.log.NDCWrapper;
import io.hops.transaction.EntityManager;
import io.hops.transaction.TransactionInfo;
import io.hops.transaction.context.TransactionsStats;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockAcquirer;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;

public abstract class TransactionalRequestHandler
extends RequestHandler {
    public TransactionalRequestHandler(RequestHandler.OperationType opType) {
        super(opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object execute(Object info) throws IOException {
        boolean committed = false;
        int tryCount = 0;
        Object txRetValue = null;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        while (tryCount <= RETRY_COUNT) {
            long expWaitTime = this.exponentialBackoff();
            long txStartTime = System.currentTimeMillis();
            long oldTime = System.currentTimeMillis();
            long setupTime = -1L;
            long beginTxTime = -1L;
            long acquireLockTime = -1L;
            long inMemoryProcessingTime = -1L;
            long commitTime = -1L;
            long totalTime = -1L;
            TransactionLockAcquirer locksAcquirer = null;
            ++tryCount;
            IOException ignoredException = null;
            committed = false;
            EntityManager.preventStorageCall(false);
            boolean success = false;
            try {
                this.setNDC(info);
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)"Pretransaction phase started");
                }
                this.preTransactionSetup();
                this.removeNDC();
                this.setNDC(info);
                setupTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)("Pretransaction phase finished. Time " + setupTime + " ms"));
                }
                this.setRandomPartitioningKey();
                EntityManager.begin();
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)"TX Started");
                }
                beginTxTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                locksAcquirer = this.newLockAcquirer();
                this.acquireLock(locksAcquirer.getLocks());
                locksAcquirer.acquire();
                acquireLockTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)("All Locks Acquired. Time " + acquireLockTime + " ms"));
                }
                this.removeNDC();
                this.setNDC(info);
                EntityManager.preventStorageCall(true);
                try {
                    txRetValue = this.performTask();
                    success = true;
                }
                catch (IOException e) {
                    if (this.shouldAbort(e)) {
                        throw e;
                    }
                    ignoredException = e;
                }
                inMemoryProcessingTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)("In Memory Processing Finished. Time " + inMemoryProcessingTime + " ms"));
                }
                TransactionsStats.TransactionStat stat = TransactionsStats.getInstance().collectStats(this.opType, ignoredException);
                EntityManager.commit(locksAcquirer.getLocks());
                committed = true;
                commitTime = System.currentTimeMillis() - oldTime;
                if (stat != null) {
                    stat.setTimes(acquireLockTime, inMemoryProcessingTime, commitTime);
                }
                if (requestHandlerLOG.isTraceEnabled()) {
                    requestHandlerLOG.trace((Object)("TX committed. Time " + commitTime + " ms"));
                }
                totalTime = System.currentTimeMillis() - txStartTime;
                if (requestHandlerLOG.isTraceEnabled()) {
                    String opName = !NDCWrapper.NDCEnabled() ? this.opType + " " : "";
                    requestHandlerLOG.trace((Object)(opName + "TX Finished. TX Time: " + totalTime + " ms, RetryCount: " + (tryCount - 1) + ", TX Stats -- Setup: " + setupTime + "ms, AcquireLocks: " + acquireLockTime + "ms, InMemoryProcessing: " + inMemoryProcessingTime + "ms, CommitTime: " + commitTime + "ms. Locks: " + this.getINodeLockInfo(locksAcquirer.getLocks())));
                }
                if (info != null && info instanceof TransactionInfo) {
                    ((TransactionInfo)info).performPostTransactionAction();
                }
            }
            catch (Throwable t) {
                boolean suppressException = this.suppressFailureMsg(t, tryCount);
                if (!suppressException) {
                    String opName = !NDCWrapper.NDCEnabled() ? this.opType + " " : "";
                    for (String subOpName : this.subOpNames) {
                        opName = opName + ":" + subOpName;
                    }
                    String inodeLocks = locksAcquirer != null ? this.getINodeLockInfo(locksAcquirer.getLocks()) : "";
                    requestHandlerLOG.warn((Object)(opName + "TX Failed. TX Time: " + (System.currentTimeMillis() - txStartTime) + " ms, RetryCount: " + (tryCount - 1) + ", TX Stats -- Setup: " + setupTime + "ms, AcquireLocks: " + acquireLockTime + "ms, InMemoryProcessing: " + inMemoryProcessingTime + "ms, CommitTime: " + commitTime + "ms. Locks: " + inodeLocks + ". " + t), t);
                }
                if (!(t instanceof TransientStorageException) || tryCount > RETRY_COUNT) {
                    for (Throwable oldExceptions : exceptions) {
                        requestHandlerLOG.warn((Object)("Exception caught during previous retry: " + oldExceptions), oldExceptions);
                    }
                    throw t;
                }
                if (suppressException) {
                    exceptions.add(t);
                }
            }
            finally {
                this.removeNDC();
                if (!committed && locksAcquirer != null) {
                    try {
                        requestHandlerLOG.trace((Object)"TX Failed. Rollback TX");
                        EntityManager.rollback(locksAcquirer.getLocks());
                    }
                    catch (Exception e) {
                        requestHandlerLOG.warn((Object)"Could not rollback transaction", (Throwable)e);
                    }
                }
                EntityManager.removeContext();
            }
            if (!success) continue;
            if (ignoredException != null) {
                throw ignoredException;
            }
            return txRetValue;
        }
        throw new RuntimeException("TransactionalRequestHandler did not execute");
    }

    private boolean suppressFailureMsg(Throwable t, int tryCount) {
        boolean suppressFailureMsg = false;
        if (this.opType.toString().equals("GET_BLOCK_LOCATIONS") && t instanceof LockUpgradeException) {
            suppressFailureMsg = true;
        } else if (this.opType.toString().equals("COMPLETE_FILE") && t instanceof OutOfDBExtentsException) {
            suppressFailureMsg = true;
        } else if (this.opType.toString().equals("GET_ADDITIONAL_BLOCK") && t.getMessage() != null && t.getMessage().contains("Not replicated yet")) {
            suppressFailureMsg = true;
        } else if (t instanceof TransientDeadLockException) {
            suppressFailureMsg = true;
        }
        return suppressFailureMsg && tryCount <= RETRY_COUNT;
    }

    private String getINodeLockInfo(TransactionLocks locks) {
        String inodeLockMsg = "";
        try {
            Lock ilock;
            if (locks != null && (ilock = locks.getLock(Lock.Type.INode)) != null) {
                inodeLockMsg = ilock.toString();
            }
        }
        catch (TransactionLocks.LockNotAddedException lockNotAddedException) {
            // empty catch block
        }
        return inodeLockMsg;
    }

    protected abstract void preTransactionSetup() throws IOException;

    public abstract void acquireLock(TransactionLocks var1) throws IOException;

    protected abstract TransactionLockAcquirer newLockAcquirer();

    @Override
    public TransactionalRequestHandler setParams(Object ... params) {
        this.params = params;
        return this;
    }

    private void setNDC(Object info) {
        if (info != null && info instanceof TransactionInfo) {
            NDCWrapper.push(((TransactionInfo)info).getContextName(this.opType));
        } else {
            NDCWrapper.push(this.opType.toString());
        }
    }

    private void removeNDC() {
        NDCWrapper.clear();
        NDCWrapper.remove();
    }

    private void setRandomPartitioningKey() throws StorageException, StorageException {
    }

    protected abstract boolean shouldAbort(Exception var1);

    protected void addSubopName(String name) {
        this.subOpNames.add(name);
    }
}

