/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.common.entity;

import io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;

public class IntVariable
extends Variable {
    private Integer value;

    public IntVariable(Variable.Finder type, int value) {
        this(type);
        this.value = value;
    }

    public IntVariable(Variable.Finder type) {
        super(type);
    }

    public IntVariable(int value) {
        this(Variable.Finder.GenericInteger, value);
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        if (val.length != this.getLength()) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(val);
        this.value = buf.getInt();
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putInt(this.value);
        return buf.array();
    }

    @Override
    public int getLength() {
        return 4;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

