/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.DispatchingInterceptor;
import com.predic8.membrane.core.interceptor.HTTPClientInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.interceptor.UserFeatureInterceptor;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import java.util.ArrayList;
import java.util.List;

public class HttpRouter
extends Router {
    public HttpRouter() {
        this(null);
    }

    public HttpRouter(ProxyConfiguration proxyConfiguration) {
        this.transport = this.createTransport(proxyConfiguration);
        this.resolverMap.getHTTPSchemaResolver().getHttpClientConfig().setProxy(proxyConfiguration);
    }

    private Transport createTransport(ProxyConfiguration proxyConfiguration) {
        HttpTransport transport = new HttpTransport();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.add(new RuleMatchingInterceptor());
        interceptors.add(new DispatchingInterceptor());
        interceptors.add(new UserFeatureInterceptor());
        HTTPClientInterceptor httpClientInterceptor = new HTTPClientInterceptor();
        interceptors.add(httpClientInterceptor);
        transport.setInterceptors(interceptors);
        return transport;
    }

    @Override
    public HttpTransport getTransport() {
        return (HttpTransport)this.transport;
    }

    public void addUserFeatureInterceptor(Interceptor i) {
        List<Interceptor> is = this.getTransport().getInterceptors();
        is.add(is.size() - 2, i);
    }
}

