/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cloud.etcd;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.http.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class EtcdResponse {
    private static JsonFactory jsonFac = new JsonFactory();
    private EtcdRequest originalRequest;
    private int statusCode = 0;
    private String body;

    public EtcdRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(EtcdRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    public EtcdResponse(EtcdRequest originalRequest, Response resp) {
        this.originalRequest = originalRequest;
        this.statusCode = resp.getStatusCode();
        this.body = resp.getBodyAsStringDecoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonParser getParser(String json) {
        JsonParser result = null;
        try {
            JsonFactory jsonFactory = jsonFac;
            synchronized (jsonFactory) {
                result = jsonFac.createParser(json);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDirectories() {
        LinkedHashMap nodeJson;
        JsonParser par = this.getParser(this.body);
        String baseKey = this.originalRequest.baseKey;
        String module = this.originalRequest.module;
        ArrayList<String> directories = new ArrayList<String>();
        Map respData = null;
        try {
            respData = (Map)new ObjectMapper().readValue(par, Map.class);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (respData.containsKey("node") && (nodeJson = (LinkedHashMap)respData.get("node")).containsKey("nodes")) {
            ArrayList nodesArray = (ArrayList)nodeJson.get("nodes");
            for (Object object : nodesArray) {
                LinkedHashMap dirs = (LinkedHashMap)object;
                if (!dirs.containsKey("key")) continue;
                String servicePath = dirs.get("key").toString();
                String uuid = servicePath.replaceAll(baseKey + module, "");
                directories.add(uuid);
            }
        }
        return directories;
    }

    public String getValue() {
        return this.get("value");
    }

    public String get(String name) {
        LinkedHashMap nodeJson;
        JsonParser par = this.getParser(this.body);
        String result = null;
        Map respData = null;
        try {
            respData = (Map)new ObjectMapper().readValue(par, Map.class);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (respData.containsKey("node") && (nodeJson = (LinkedHashMap)respData.get("node")).containsKey(name)) {
            result = nodeJson.get(name).toString();
        }
        if (result == null) {
            throw new RuntimeException();
        }
        return result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statuscode) {
        this.statusCode = statuscode;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean is2XX() {
        return this.checkStatusCode(200, 300);
    }

    private boolean isInRange(int minInclusive, int maxExclusive, int value) {
        return value >= minInclusive && value < maxExclusive;
    }

    private boolean checkStatusCode(int minInc, int maxExc) {
        return this.isInRange(minInc, maxExc, this.getStatusCode());
    }
}

