/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange.snapshots;

import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageSnapshot {
    Map<String, String> header;
    String body = null;

    public MessageSnapshot(Message msg) {
        this.header = Stream.of(msg.getHeader().getAllHeaderFields()).collect(Collectors.toMap(headerField -> headerField.getHeaderName().toString(), headerField -> headerField.getValue()));
        if (!msg.getHeader().isBinaryContentType()) {
            this.body = msg.getBodyAsStringDecoded();
        }
    }

    public MessageSnapshot() {
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Header convertHeader() {
        Header result = new Header();
        this.header.keySet().stream().forEach(key -> result.add((String)key, this.header.get(key)));
        return result;
    }

    public AbstractBody convertBody() {
        if (this.body == null) {
            return new EmptyBody();
        }
        return new Body(this.body.getBytes());
    }
}

