/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchangestore;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.ClientStatistics;

public class ClientStatisticsCollector
implements ClientStatistics {
    private int count;
    private long minDuration = Long.MAX_VALUE;
    private long maxDuration = Long.MIN_VALUE;
    private long total;
    private String client;

    public ClientStatisticsCollector(String client) {
        this.client = client;
    }

    public void collect(AbstractExchange exc) {
        if (this.getDuration(exc) < this.minDuration) {
            this.minDuration = this.getDuration(exc);
        }
        if (this.getDuration(exc) > this.maxDuration) {
            this.maxDuration = this.getDuration(exc);
        }
        this.total += this.getDuration(exc);
        ++this.count;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public long getMinDuration() {
        return this.minDuration;
    }

    @Override
    public long getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public long getAvgDuration() {
        return this.total / (long)this.count;
    }

    private long getDuration(AbstractExchange exc) {
        return exc.getTimeResReceived() - exc.getTimeReqSent();
    }
}

