/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractBodyTransferrer;
import com.predic8.membrane.core.http.BodyInputStream;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedBody
extends AbstractBody {
    private static final Logger log = LoggerFactory.getLogger((String)ChunkedBody.class.getName());
    private InputStream inputStream;
    boolean bodyObserved = false;
    boolean bodyComplete = false;

    public ChunkedBody(InputStream in) {
        log.debug("ChunkedInOutBody constructor");
        this.inputStream = in;
    }

    @Override
    public void read() throws IOException {
        if (this.bodyObserved && !this.bodyComplete) {
            ByteUtil.readStream(this.getContentAsStream());
        }
        this.bodyObserved = true;
        super.read();
    }

    @Override
    public void write(AbstractBodyTransferrer out) throws IOException {
        if (this.bodyObserved && !this.bodyComplete) {
            ByteUtil.readStream(this.getContentAsStream());
        }
        super.write(out);
    }

    @Override
    protected void markAsRead() {
        super.markAsRead();
        this.bodyComplete = true;
    }

    @Override
    protected void readLocal() throws IOException {
        this.chunks.addAll(HttpUtil.readChunks(this.inputStream));
    }

    @Override
    public void discard() throws IOException {
        if (this.read) {
            return;
        }
        for (MessageObserver observer : this.observers) {
            observer.bodyRequested(this);
        }
        HttpUtil.readChunksAndDrop(this.inputStream);
        this.markAsRead();
    }

    @Override
    public InputStream getContentAsStream() throws IOException {
        this.read = true;
        if (!this.bodyObserved) {
            this.bodyObserved = true;
            for (MessageObserver observer : this.observers) {
                observer.bodyRequested(this);
            }
            this.chunks.clear();
        }
        return new BodyInputStream(this.chunks){

            @Override
            protected Chunk readNextChunk() throws IOException {
                if (ChunkedBody.this.bodyComplete) {
                    return null;
                }
                int chunkSize = HttpUtil.readChunkSize(ChunkedBody.this.inputStream);
                if (chunkSize > 0) {
                    Chunk c = new Chunk(ByteUtil.readByteArray(ChunkedBody.this.inputStream, chunkSize));
                    ChunkedBody.this.inputStream.read();
                    ChunkedBody.this.inputStream.read();
                    return c;
                }
                ChunkedBody.this.inputStream.read();
                ChunkedBody.this.inputStream.read();
                ChunkedBody.this.bodyComplete = true;
                for (MessageObserver observer : ChunkedBody.this.observers) {
                    observer.bodyComplete(ChunkedBody.this);
                }
                ChunkedBody.this.observers.clear();
                return null;
            }
        };
    }

    @Override
    protected void writeNotRead(AbstractBodyTransferrer out) throws IOException {
        int chunkSize;
        log.debug("writeNotReadChunked");
        while ((chunkSize = HttpUtil.readChunkSize(this.inputStream)) > 0) {
            Chunk chunk = new Chunk(ByteUtil.readByteArray(this.inputStream, chunkSize));
            out.write(chunk);
            this.chunks.add(chunk);
            this.inputStream.read();
            this.inputStream.read();
        }
        this.inputStream.read();
        this.inputStream.read();
        out.finish();
        this.markAsRead();
    }

    @Override
    protected void writeStreamed(AbstractBodyTransferrer out) throws IOException {
        int chunkSize;
        log.debug("writeStreamed");
        while ((chunkSize = HttpUtil.readChunkSize(this.inputStream)) > 0) {
            Chunk chunk = new Chunk(ByteUtil.readByteArray(this.inputStream, chunkSize));
            out.write(chunk);
            this.inputStream.read();
            this.inputStream.read();
        }
        this.inputStream.read();
        this.inputStream.read();
        out.finish();
        this.markAsRead();
    }

    protected int getRawLength() throws IOException {
        if (this.chunks.isEmpty()) {
            return 0;
        }
        int length = this.getLength();
        for (Chunk chunk : this.chunks) {
            length += Long.toHexString(chunk.getLength()).getBytes(Constants.UTF_8_CHARSET).length;
            length += 2 * Constants.CRLF_BYTES.length;
        }
        length += "0".getBytes(Constants.UTF_8_CHARSET).length;
        return length += 2 * Constants.CRLF_BYTES.length;
    }

    @Override
    protected byte[] getRawLocal() throws IOException {
        byte[] raw = new byte[this.getRawLength()];
        int destPos = 0;
        for (Chunk chunk : this.chunks) {
            destPos = chunk.copyChunkLength(raw, destPos, this);
            destPos = this.copyCRLF(raw, destPos);
            destPos = chunk.copyChunk(raw, destPos);
            destPos = this.copyCRLF(raw, destPos);
        }
        destPos = this.copyLastChunk(raw, destPos);
        destPos = this.copyCRLF(raw, destPos);
        return raw;
    }

    private int copyLastChunk(byte[] raw, int destPos) {
        System.arraycopy(ChunkedBodyTransferrer.ZERO, 0, raw, destPos, ChunkedBodyTransferrer.ZERO.length);
        destPos += ChunkedBodyTransferrer.ZERO.length;
        destPos = this.copyCRLF(raw, destPos);
        return destPos;
    }

    private int copyCRLF(byte[] raw, int destPos) {
        System.arraycopy(Constants.CRLF_BYTES, 0, raw, destPos, 2);
        return destPos += 2;
    }

    @Override
    protected void writeAlreadyRead(AbstractBodyTransferrer out) throws IOException {
        if (this.getLength() == 0) {
            return;
        }
        for (Chunk chunk : this.chunks) {
            out.write(chunk);
        }
        out.finish();
    }
}

