/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.google.common.collect.Sets;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.ChunkedBody;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingLineException;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
extends Message {
    private static final Logger log = LoggerFactory.getLogger((String)Request.class.getName());
    private static final Pattern pattern = Pattern.compile("(.+?) (.+?) HTTP/(.+?)$");
    private static final Pattern stompPattern = Pattern.compile("^(.+?)$");
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_CONNECT = "CONNECT";
    public static final String METHOD_OPTIONS = "OPTIONS";
    private static final HashSet<String> methodsWithoutBody = Sets.newHashSet((Object[])new String[]{"GET", "HEAD", "CONNECT"});
    private static final HashSet<String> methodsWithOptionalBody = Sets.newHashSet((Object[])new String[]{"DELETE", "PROPFIND", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK"});
    String method;
    String uri;

    @Override
    public void parseStartLine(InputStream in) throws IOException, EndOfStreamException {
        block5: {
            try {
                String firstLine = HttpUtil.readLine(in);
                Matcher matcher = pattern.matcher(firstLine);
                if (matcher.find()) {
                    this.method = matcher.group(1);
                    this.uri = matcher.group(2);
                    this.version = matcher.group(3);
                    break block5;
                }
                if (stompPattern.matcher(firstLine).find()) {
                    this.method = firstLine;
                    this.uri = "";
                    this.version = "STOMP";
                    break block5;
                }
                throw new EOFWhileReadingFirstLineException(firstLine);
            }
            catch (EOFWhileReadingLineException e) {
                if (e.getLineSoFar().length() == 0) {
                    throw new NoMoreRequestsException();
                }
                throw new EOFWhileReadingFirstLineException(e.getLineSoFar());
            }
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void create(String method, String uri, String protocol, Header header, InputStream in) throws IOException {
        this.method = method;
        this.uri = uri;
        if (!protocol.startsWith("HTTP/")) {
            throw new RuntimeException("Unknown protocol '" + protocol + "'");
        }
        this.version = protocol.substring(5);
        this.header = header;
        this.createBody(in);
    }

    @Override
    public String getStartLine() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.method);
        buf.append(" ");
        buf.append(this.uri);
        buf.append(" HTTP/");
        buf.append(this.version);
        buf.append("\r\n");
        return buf.toString();
    }

    @Override
    protected void createBody(InputStream in) throws IOException {
        log.debug("createBody");
        if (this.isBodyEmpty()) {
            log.debug("empty body created");
            this.body = new EmptyBody();
            return;
        }
        super.createBody(in);
    }

    public boolean isHEADRequest() {
        return METHOD_HEAD.equals(this.method);
    }

    public boolean isGETRequest() {
        return METHOD_GET.equals(this.method);
    }

    public boolean isPOSTRequest() {
        return METHOD_POST.equals(this.method);
    }

    public boolean isDELETERequest() {
        return METHOD_DELETE.equals(this.method);
    }

    public boolean isCONNECTRequest() {
        return METHOD_CONNECT.equals(this.method);
    }

    public boolean isOPTIONSRequest() {
        return METHOD_OPTIONS.equals(this.method);
    }

    @Override
    public String getName() {
        return this.uri;
    }

    @Override
    public boolean isBodyEmpty() throws IOException {
        if (methodsWithoutBody.contains(this.method)) {
            return true;
        }
        if (methodsWithOptionalBody.contains(this.method)) {
            if (this.header.hasContentLength()) {
                return this.header.getContentLength() == 0L;
            }
            return !(this.getBody() instanceof ChunkedBody);
        }
        return super.isBodyEmpty();
    }

    public boolean isBindTargetConnectionToIncoming() {
        String auth = this.header.getFirstValue("Authorization");
        return auth != null && (auth.startsWith("NTLM") || auth.startsWith("Negotiate"));
    }

    @Override
    public int estimateHeapSize() {
        return super.estimateHeapSize() + 12 + (this.method != null ? 2 * this.method.length() : 0) + (this.uri != null ? 2 * this.uri.length() : 0);
    }

    @Override
    public <T extends Message> T createSnapshot() throws Exception {
        Request result = this.createMessageSnapshot(new Request());
        result.setUri(this.getUri());
        result.setMethod(this.getMethod());
        return (T)result;
    }

    public final void writeSTOMP(OutputStream out) throws IOException {
        out.write(this.getMethod().getBytes("UTF-8"));
        out.write(10);
        for (HeaderField hf : this.header.getAllHeaderFields()) {
            out.write((hf.getHeaderName().toString() + ":" + hf.getValue() + "\n").getBytes("UTF-8"));
        }
        out.write(10);
        this.body.write(new PlainBodyTransferrer(out));
    }

    public static class Builder {
        private Request req = new Request();
        private String fullURL;

        public Builder() {
            this.req.setVersion("1.1");
        }

        public Request build() {
            return this.req;
        }

        public Exchange buildExchange() {
            Exchange exc = new Exchange(null);
            exc.setRequest(this.build());
            exc.getDestinations().add(this.fullURL);
            return exc;
        }

        public Builder method(String method) {
            this.req.setMethod(method);
            return this;
        }

        public Builder url(URIFactory uriFactory, String url) throws URISyntaxException {
            this.fullURL = url;
            this.req.setUri(URLUtil.getPathQuery(uriFactory, url));
            return this;
        }

        public Builder header(String headerName, String headerValue) {
            this.req.getHeader().add(headerName, headerValue);
            return this;
        }

        public Builder contentType(String value) {
            this.req.getHeader().add("Content-Type", value);
            return this;
        }

        public Builder header(Header headers) {
            this.req.setHeader(headers);
            return this;
        }

        public Builder body(String body) {
            this.req.setBodyContent(body.getBytes());
            return this;
        }

        public Builder body(byte[] body) {
            this.req.setBodyContent(body);
            return this;
        }

        public Builder body(long contentLength, InputStream body) throws IOException {
            this.req.body = new Body(body, contentLength);
            Header header = this.req.getHeader();
            header.removeFields("Content-Encoding");
            header.removeFields("Transfer-Encoding");
            header.setContentLength(contentLength);
            return this;
        }

        public Builder post(URIFactory uriFactory, String url) throws URISyntaxException {
            return this.method(Request.METHOD_POST).url(uriFactory, url);
        }

        public Builder post(String url) throws URISyntaxException {
            return this.post(new URIFactory(), url);
        }

        public Builder get(URIFactory uriFactory, String url) throws URISyntaxException {
            return this.method(Request.METHOD_GET).url(uriFactory, url);
        }

        public Builder get(String url) throws URISyntaxException {
            return this.get(new URIFactory(), url);
        }

        public Builder delete(URIFactory uriFactory, String url) throws URISyntaxException {
            return this.method(Request.METHOD_DELETE).url(uriFactory, url);
        }

        public Builder delete(String url) throws URISyntaxException {
            return this.delete(new URIFactory(), url);
        }

        public Builder put(URIFactory uriFactory, String url) throws URISyntaxException {
            return this.method(Request.METHOD_PUT).url(uriFactory, url);
        }

        public Builder put(String url) throws URISyntaxException {
            return this.put(new URIFactory(), url);
        }
    }
}

