/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.ServiceProxyKey;
import com.predic8.membrane.core.transport.http.HostColonPort;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

@MCElement(name="index", id="index-interceptor")
public class IndexInterceptor
extends AbstractInterceptor {
    public List<ServiceInfo> getServices(Exchange exc) {
        ArrayList<ServiceInfo> result = new ArrayList<ServiceInfo>();
        for (Rule r : this.router.getRuleManager().getRules()) {
            ServiceInfo si;
            if (!(r instanceof AbstractServiceProxy) || (si = this.getServiceInfo(exc, (AbstractServiceProxy)r)) == null) continue;
            result.add(si);
        }
        return result;
    }

    private ServiceInfo getServiceInfo(Exchange exc, AbstractServiceProxy sp) {
        int port;
        String host;
        if (sp.getInterceptors().size() == 1 && sp.getInterceptors().get(0) instanceof IndexInterceptor) {
            return null;
        }
        ServiceProxyKey k = (ServiceProxyKey)sp.getKey();
        ServiceInfo ri = new ServiceInfo();
        ri.method = k.getMethod();
        ri.ssl = sp.getSslInboundContext() != null;
        String protocol = ri.ssl ? "https" : "http";
        String string = host = k.isHostWildcard() ? new HostColonPort((boolean)ri.ssl, (String)exc.getRequest().getHeader().getHost()).host : IndexInterceptor.fullfillRegexp(ServiceProxyKey.createHostPattern(k.getHost()));
        if (host == null || host.length() == 0) {
            host = exc.getHandler().getLocalAddress().getHostAddress().toString();
        }
        if ((port = k.getPort()) == -1 || !exc.getHandler().isMatchLocalPort()) {
            port = exc.getHandler().getLocalPort();
        }
        String path = !k.isUsePathPattern() ? "/" : (k.isPathRegExp() ? IndexInterceptor.fullfillRegexp(k.getPath()) : "/" + StringUtils.removeStart((String)k.getPath(), (String)"/"));
        if (!"".equals(exc.getHandler().getContextPath(exc))) {
            path = StringUtils.removeEnd((String)exc.getHandler().getContextPath(exc), (String)"/") + "/" + StringUtils.removeStart((String)path, (String)"/");
        }
        ri.name = sp.getName();
        if (path != null) {
            ri.url = protocol + "://" + host + ":" + port + path;
        }
        ri.host = k.isHostWildcard() ? "" : StringEscapeUtils.escapeHtml((String)k.getHost());
        String string2 = ri.port = k.getPort() == -1 ? "" : "" + k.getPort();
        ri.path = k.isUsePathPattern() ? "<tt>" + StringEscapeUtils.escapeHtml((String)k.getPath()) + "</tt>" + (k.isPathRegExp() ? " (regex)" : "") : "";
        return ri;
    }

    static String fullfillRegexp(String regex) {
        StringBuilder sb = new StringBuilder();
        int p = 0;
        int groupLevel = 0;
        block15: while (p < regex.length()) {
            int c = regex.codePointAt(p++);
            block0 : switch (c) {
                case 92: {
                    if (p == regex.length()) {
                        return null;
                    }
                    if (Character.isDigit(c = regex.codePointAt(p++))) {
                        return null;
                    }
                    if (c == 81) {
                        while (true) {
                            if (p == regex.length()) {
                                return null;
                            }
                            if ((c = regex.codePointAt(p++)) == 92) {
                                if (p == regex.length()) {
                                    return null;
                                }
                                if ((c = regex.codePointAt(p++)) == 69) break block0;
                                sb.append('\\');
                            }
                            sb.appendCodePoint(c);
                        }
                    }
                    if (c == 69) {
                        return null;
                    }
                    sb.appendCodePoint(c);
                    break;
                }
                case 42: 
                case 43: 
                case 63: 
                case 91: 
                case 123: {
                    return null;
                }
                case 40: {
                    ++groupLevel;
                    break;
                }
                case 41: {
                    if (groupLevel == 0) {
                        return null;
                    }
                    --groupLevel;
                    break;
                }
                case 124: {
                    if (groupLevel == 0) break block15;
                    block17: while (true) {
                        if (++p == regex.length()) {
                            return null;
                        }
                        switch (regex.charAt(p)) {
                            case ')': {
                                break block17;
                            }
                            case '*': 
                            case '+': 
                            case '?': 
                            case '[': 
                            case '{': {
                                return null;
                            }
                            case '\\': {
                                return null;
                            }
                            default: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    --groupLevel;
                    ++p;
                    break;
                }
                case 94: {
                    if (p == 1) break;
                    return null;
                }
                case 36: {
                    if (p == regex.length()) continue block15;
                    if (regex.codePointAt(p) == 124) break;
                    return null;
                }
                case 46: {
                    int q;
                    if (p != regex.length() && IndexInterceptor.isQuantifier(q = regex.codePointAt(p))) {
                        if (++p != regex.length() && IndexInterceptor.isModifier(regex.codePointAt(p))) {
                            ++p;
                        }
                        if (q != 43) continue block15;
                        sb.append('a');
                        break;
                    }
                    sb.append('a');
                    break;
                }
                default: {
                    sb.appendCodePoint(c);
                }
            }
        }
        if (groupLevel > 0) {
            return null;
        }
        return sb.toString();
    }

    private static boolean isQuantifier(int c) {
        return c == 63 || c == 42 || c == 43;
    }

    private static boolean isModifier(int c) {
        return c == 63 || c == 43;
    }

    @Override
    public Outcome handleRequest(final Exchange exc) throws Exception {
        StringWriter sw = new StringWriter();
        new Html(sw){
            {
                super(x0);
                this.html();
                this.head();
                ((Html)((Html)this.title()).text("Membrane Service Proxy: Service Proxies")).end();
                this.style();
                this.raw("<!--\r\nbody { font-family: sans-serif; }\r\nh1 { font-size: 24pt; }\r\ntd, th { border: 1px solid black; padding: 0pt 10pt; }\r\ntable { border-collapse: collapse; }\r\n.help { margin-top:20pt; color:#AAAAAA; padding:1em 0em 0em 0em; font-size:10pt; }\r\n.footer { color:#AAAAAA; padding:0em 0em; font-size:10pt; }\r\n.footer a { color:#AAAAAA; }\r\n.footer a:hover { color:#000000; }\r\n-->");
                this.end();
                this.end();
                this.body();
                ((Html)((Html)this.h1()).text("Service Proxies")).end();
                List<ServiceInfo> services = IndexInterceptor.this.getServices(exc);
                if (services.isEmpty()) {
                    ((Html)((Html)this.p()).text("There are no services defined.")).end();
                } else {
                    this.createIndexTable(services, exc.getHandler() instanceof HttpServerHandler);
                }
                ((Html)((Html)((Html)this.p()).classAttr("help")).text("The hyperlinks might not work due to semantics which is not known to Membrane Service Proxy.")).end();
                ((Html)((Html)((Html)this.p()).classAttr("footer")).raw("Copyright \u00a92009-2016 <a href=\"http://predic8.com/\">predic8 GmbH</a>. All Rights Reserved. See <a href=\"http://www.membrane-soa.org/service-proxy/\">http://www.membrane-soa.org/service-proxy/</a> for documentation and updates.")).end();
                this.end();
                this.end();
            }

            private void createIndexTable(List<ServiceInfo> services, boolean showSSL) {
                ((Html)((Html)((Html)this.table()).cellspacing("0")).cellpadding("0")).border("1");
                this.tr();
                ((Html)((Html)this.th()).text("Name")).end();
                ((Html)((Html)this.th()).text("Virtual Host")).end();
                ((Html)((Html)this.th()).text("Port")).end();
                ((Html)((Html)this.th()).text("Path")).end();
                if (showSSL) {
                    ((Html)((Html)this.th()).text("SSL")).end();
                }
                this.end();
                for (ServiceInfo ri : services) {
                    this.tr();
                    this.td();
                    if (ri.url != null && !"POST".equals(ri.method)) {
                        ((Html)this.a()).href(ri.url);
                        this.text(ri.name);
                        this.end();
                    } else {
                        this.text(ri.name);
                    }
                    this.end();
                    ((Html)((Html)this.td()).raw(ri.host)).end();
                    ((Html)((Html)this.td()).raw(ri.port)).end();
                    ((Html)((Html)this.td()).raw(ri.path)).end();
                    if (showSSL) {
                        ((Html)((Html)this.td()).raw(ri.ssl ? "yes" : "")).end();
                    }
                    this.end();
                }
                this.end();
            }
        };
        exc.setResponse(Response.ok(sw.toString()).build());
        return Outcome.RETURN;
    }

    @Override
    public String getShortDescription() {
        return "Lists services available through the Membrane Service Proxy service proxies.";
    }

    private static class ServiceInfo {
        public String name;
        public String url;
        public String host;
        public String port;
        public String path;
        public boolean ssl;
        public String method;

        private ServiceInfo() {
        }
    }
}

