/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.token.Token;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.LogInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.CleanupThread;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AnswerParameters;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Statistics;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import com.predic8.membrane.core.interceptor.server.WebServerInterceptor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.util.URI;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="oauth2Resource")
public class OAuth2ResourceInterceptor
extends AbstractInterceptor {
    public static final String OAUTH2_ANSWER = "oauth2Answer";
    public static final String OA2REDIRECT = "oa2redirect";
    private static Logger log = LoggerFactory.getLogger((String)OAuth2ResourceInterceptor.class.getName());
    private String loginLocation;
    private String loginPath = "/login/";
    private String publicURL;
    private SessionManager sessionManager;
    private AuthorizationService auth;
    private OAuth2Statistics statistics;
    private Cache<String, Boolean> validTokens = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private Cache<String, Exchange> stateToRedirect = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private int revalidateTokenAfter = -1;
    private ConcurrentHashMap<String, Exchange> stateToOriginalUrl = new ConcurrentHashMap();
    private WebServerInterceptor wsi;
    private URIFactory uriFactory;
    private boolean firstInitWhenDynamicAuthorizationService;
    private boolean initPublicURLOnFirstExchange = false;

    public String getLoginLocation() {
        return this.loginLocation;
    }

    @MCAttribute
    public void setLoginLocation(String login) {
        this.loginLocation = login;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    @MCAttribute
    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public String getPublicURL() {
        return this.publicURL;
    }

    @MCAttribute
    public void setPublicURL(String publicURL) {
        this.publicURL = publicURL;
    }

    public AuthorizationService getAuthService() {
        return this.auth;
    }

    @Required
    @MCChildElement(order=10)
    public void setAuthService(AuthorizationService auth) {
        this.auth = auth;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @MCChildElement(order=20)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public int getRevalidateTokenAfter() {
        return this.revalidateTokenAfter;
    }

    @MCAttribute
    public void setRevalidateTokenAfter(int revalidateTokenAfter) {
        this.revalidateTokenAfter = revalidateTokenAfter;
    }

    @Override
    public void init(Router router) throws Exception {
        this.name = "OAuth 2 Client";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE);
        super.init(router);
        this.auth.init(router);
        this.statistics = new OAuth2Statistics();
        this.uriFactory = router.getUriFactory();
        if (this.sessionManager == null) {
            this.sessionManager = new SessionManager();
        }
        this.sessionManager.setCookieName("SESSION_ID_CLIENT");
        this.sessionManager.init(router);
        if (this.loginLocation != null) {
            this.wsi = new WebServerInterceptor();
            this.wsi.setDocBase(this.loginLocation);
            router.getResolverMap().resolve(ResolverMap.combine(router.getBaseLocation(), this.wsi.getDocBase(), "./index.html")).close();
            this.wsi.init(router);
        }
        if (this.publicURL == null) {
            this.initPublicURLOnFirstExchange = true;
        } else {
            this.normalizePublicURL();
        }
        this.firstInitWhenDynamicAuthorizationService = this.getAuthService().supportsDynamicRegistration();
        if (!this.getAuthService().supportsDynamicRegistration()) {
            this.firstInitWhenDynamicAuthorizationService = false;
        }
        new CleanupThread(this.sessionManager).start();
    }

    @Override
    public final Outcome handleRequest(Exchange exc) throws Exception {
        Outcome outcome = this.handleRequestInternal(exc);
        if (outcome != Outcome.CONTINUE) {
            this.sessionManager.postProcess(exc);
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome handleRequestInternal(Exchange exc) throws Exception {
        String auth;
        if (this.initPublicURLOnFirstExchange) {
            this.setPublicURL(exc);
        }
        if (this.firstInitWhenDynamicAuthorizationService) {
            this.firstInitWhenDynamicAuthorizationService = false;
            this.getAuthService().dynamicRegistration(exc, this.publicURL);
        }
        if (this.isFaviconRequest(exc)) {
            exc.setResponse(Response.badRequest().build());
            return Outcome.RETURN;
        }
        if (this.isOAuth2RedirectRequest(exc)) {
            this.handleOriginalRequest(exc);
        }
        if (this.isLoginRequest(exc)) {
            this.handleLoginRequest(exc);
            return Outcome.RETURN;
        }
        SessionManager.Session session = this.sessionManager.getSession(exc);
        if (session == null && (auth = exc.getRequest().getHeader().getFirstValue("Authorization")) != null && auth.substring(0, 7).equalsIgnoreCase("Bearer ")) {
            session = this.sessionManager.createSession(exc);
            session.getUserAttributes().put("access_token", auth.substring(7));
            OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
            oauth2Answer.setAccessToken(auth.substring(7));
            oauth2Answer.setTokenType("Bearer");
            HashMap<String, String> userinfo = this.revalidateToken(oauth2Answer);
            if (userinfo == null) {
                return this.respondWithRedirect(exc);
            }
            oauth2Answer.setUserinfo(userinfo);
            session.getUserAttributes().put(OAUTH2_ANSWER, oauth2Answer.serialize());
            this.processUserInfo(userinfo, session);
        }
        if (session == null) {
            return this.respondWithRedirect(exc);
        }
        if (session.getUserAttributes().get(OAUTH2_ANSWER) != null && this.tokenNeedsRevalidation(session.getUserAttributes().get("access_token")) && this.revalidateToken(OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER))) == null) {
            session.clear();
        }
        if (session.getUserAttributes().get(OAUTH2_ANSWER) != null) {
            exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER)));
        }
        if (this.refreshingOfAccessTokenIsNeeded(session)) {
            SessionManager.Session session2 = session;
            synchronized (session2) {
                this.refreshAccessToken(session);
                exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER)));
            }
        }
        if (session.isAuthorized()) {
            this.applyBackendAuthorization(exc, session);
            this.statistics.successfulRequest();
            return Outcome.CONTINUE;
        }
        if (this.handleRequest(exc, session.getUserAttributes().get("state"), this.publicURL, session)) {
            if (exc.getResponse() == null && exc.getRequest() != null && session.isAuthorized() && session.getUserAttributes().containsKey(OAUTH2_ANSWER)) {
                exc.setProperty("oauth2", OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER)));
                return Outcome.CONTINUE;
            }
            if (exc.getResponse().getStatusCode() >= 400) {
                session.clear();
            }
            return Outcome.RETURN;
        }
        return this.respondWithRedirect(exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOriginalRequest(Exchange exc) throws Exception {
        Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc);
        String oa2redirect = params.get(OA2REDIRECT);
        Exchange originalExchange = null;
        Cache<String, Exchange> cache = this.stateToRedirect;
        synchronized (cache) {
            originalExchange = (Exchange)this.stateToRedirect.getIfPresent((Object)oa2redirect);
            this.stateToRedirect.invalidate((Object)oa2redirect);
        }
        this.doOriginalRequest(exc, originalExchange);
    }

    private boolean isOAuth2RedirectRequest(Exchange exc) {
        return exc.getOriginalRequestUri().contains(OA2REDIRECT);
    }

    private void refreshAccessToken(SessionManager.Session session) throws Exception {
        if (!this.refreshingOfAccessTokenIsNeeded(session)) {
            return;
        }
        OAuth2AnswerParameters oauth2Params = OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER));
        Exchange refreshTokenExchange = new Request.Builder().post(this.auth.getTokenEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT).body("&grant_type=refresh_token&refresh_token=" + oauth2Params.getRefreshToken()).buildExchange();
        Response refreshTokenResponse = this.auth.doRequest(refreshTokenExchange);
        if (!refreshTokenResponse.isOk()) {
            refreshTokenResponse.getBody().read();
            throw new RuntimeException("Statuscode from authorization server for refresh token request: " + refreshTokenResponse.getStatusCode());
        }
        HashMap<String, String> json = Util.parseSimpleJSONResponse(refreshTokenResponse);
        if (json.get("access_token") == null || json.get("refresh_token") == null) {
            refreshTokenResponse.getBody().read();
            throw new RuntimeException("Statuscode was ok but no access_token and refresh_token was received: " + refreshTokenResponse.getStatusCode());
        }
        oauth2Params.setAccessToken(json.get("access_token"));
        oauth2Params.setRefreshToken(json.get("refresh_token"));
        oauth2Params.setExpiration(json.get("expires_in"));
        oauth2Params.setReceivedAt(LocalDateTime.now());
        if (json.containsKey("id_token")) {
            if (this.idTokenIsValid(json.get("id_token"))) {
                oauth2Params.setIdToken(json.get("id_token"));
            } else {
                oauth2Params.setIdToken("INVALID");
            }
        }
        session.getUserAttributes().put(OAUTH2_ANSWER, oauth2Params.serialize());
    }

    private boolean refreshingOfAccessTokenIsNeeded(SessionManager.Session session) throws IOException {
        if (session.getUserAttributes().get(OAUTH2_ANSWER) == null) {
            return false;
        }
        OAuth2AnswerParameters oauth2Params = OAuth2AnswerParameters.deserialize(session.getUserAttributes().get(OAUTH2_ANSWER));
        if (oauth2Params.getRefreshToken() == null || oauth2Params.getRefreshToken().isEmpty() || oauth2Params.getExpiration() == null || oauth2Params.getExpiration().isEmpty()) {
            return false;
        }
        return LocalDateTime.now().isAfter(oauth2Params.getReceivedAt().plusSeconds(Long.parseLong(oauth2Params.getExpiration())).minusSeconds(5L));
    }

    private HashMap<String, String> revalidateToken(OAuth2AnswerParameters params) throws Exception {
        Exchange e2 = new Request.Builder().get(this.auth.getUserInfoEndpoint()).header("Authorization", params.getTokenType() + " " + params.getAccessToken()).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange();
        Response response2 = this.auth.doRequest(e2);
        if (response2.getStatusCode() != 200) {
            this.statistics.accessTokenInvalid();
            return null;
        }
        this.statistics.accessTokenValid();
        return Util.parseSimpleJSONResponse(response2);
    }

    private boolean tokenNeedsRevalidation(String token) {
        if (this.revalidateTokenAfter < 0) {
            return false;
        }
        return this.validTokens.getIfPresent((Object)token) == null;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.sessionManager.postProcess(exc);
        return super.handleResponse(exc);
    }

    private void setPublicURL(Exchange exc) {
        String xForwardedProto = exc.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        boolean isHTTPS = xForwardedProto != null ? "https".equals(xForwardedProto) : exc.getRule().getSslInboundContext() != null;
        this.publicURL = (isHTTPS ? "https://" : "http://") + exc.getOriginalHostHeader();
        RuleKey key = exc.getRule().getKey();
        if (!key.isPathRegExp() && key.getPath() != null) {
            this.publicURL = this.publicURL + key.getPath();
        }
        this.normalizePublicURL();
        this.initPublicURLOnFirstExchange = false;
    }

    private void normalizePublicURL() {
        if (!this.publicURL.endsWith("/")) {
            this.publicURL = this.publicURL + "/";
        }
    }

    private boolean isFaviconRequest(Exchange exc) {
        return exc.getRequestURI().startsWith("/favicon.ico");
    }

    private void applyBackendAuthorization(Exchange exc, SessionManager.Session s) {
        Header h = exc.getRequest().getHeader();
        for (Map.Entry<String, String> e : s.getUserAttributes().entrySet()) {
            if (!e.getKey().startsWith("header")) continue;
            String headerName = e.getKey().substring(6);
            h.removeFields(headerName);
            h.add(headerName, e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome respondWithRedirect(Exchange exc) {
        if (this.loginLocation == null) {
            SessionManager.Session session;
            String state = new BigInteger(130, new SecureRandom()).toString(32);
            exc.setResponse(Response.redirect(this.auth.getLoginURL(state, this.publicURL, exc.getRequestURI()), false).build());
            this.stateToOriginalUrl.put(state, exc);
            SessionManager.Session session2 = session = this.sessionManager.getOrCreateSession(exc);
            synchronized (session2) {
                if (session.getUserAttributes().containsKey("state")) {
                    state = session.getUserAttributes().get("state") + " " + state;
                }
                if (!session.isPreAuthorized() || !session.isAuthorized()) {
                    session.preAuthorize("", new HashMap<String, String>());
                }
                session.getUserAttributes().put("state", state);
            }
        } else {
            exc.setResponse(Response.redirect(this.loginPath, false).build());
        }
        return Outcome.RETURN;
    }

    public boolean isLoginRequest(Exchange exc) {
        URI uri = this.router.getUriFactory().createWithoutException(exc.getRequest().getUri());
        return uri.getPath().startsWith(this.loginPath);
    }

    private void showPage(Exchange exc, String state, Object ... params) throws Exception {
        String target = StringUtils.defaultString((String)URLParamUtil.getParams(this.router.getUriFactory(), exc).get("target"));
        exc.getDestinations().set(0, "/index.html");
        this.wsi.handleRequest(exc);
        Engine engine = new Engine();
        engine.setErrorHandler(new ErrorHandler(){

            public void error(String arg0, Token arg1, Map<String, Object> arg2) throws ParseException {
                log.error(arg0);
            }

            public void error(String arg0, Token arg1) throws ParseException {
                log.error(arg0);
            }
        });
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("loginPath", StringEscapeUtils.escapeXml((String)this.loginPath));
        String pathQuery = "/";
        String url = this.auth.getLoginURL(state, this.publicURL, pathQuery);
        model.put("loginURL", url);
        model.put("target", StringEscapeUtils.escapeXml((String)target));
        model.put("authid", state);
        for (int i = 0; i < params.length; i += 2) {
            model.put((String)params[i], params[i + 1]);
        }
        exc.getResponse().setBodyContent(engine.transform(exc.getResponse().getBodyAsStringDecoded(), model).getBytes(Constants.UTF_8_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLoginRequest(Exchange exc) throws Exception {
        SessionManager.Session s = this.sessionManager.getSession(exc);
        String uri = exc.getRequest().getUri().substring(this.loginPath.length() - 1);
        if (uri.indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        exc.getDestinations().set(0, uri);
        if (uri.equals("/logout")) {
            if (s != null && s.getUserAttributes() != null) {
                String token;
                SessionManager.Session session = s;
                synchronized (session) {
                    token = s.getUserAttributes().get("access_token");
                }
                Exchange e = new Request.Builder().post(this.auth.getRevocationEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").header("User-Agent", Constants.USERAGENT).body("token=" + token).buildExchange();
                Response response = this.auth.doRequest(e);
                if (response.getStatusCode() != 200) {
                    throw new RuntimeException("Revocation of token did not work. Statuscode: " + response.getStatusCode() + ".");
                }
                s.clear();
                this.sessionManager.removeSession(exc);
            }
            exc.setResponse(Response.redirect("/", false).build());
        } else if (uri.equals("/")) {
            if (s == null || !s.isAuthorized()) {
                String state = new BigInteger(130, new SecureRandom()).toString(32);
                this.showPage(exc, state, new Object[0]);
                SessionManager.Session session = this.sessionManager.createSession(exc);
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                userAttributes.put("state", state);
                session.preAuthorize("", userAttributes);
            } else {
                this.showPage(exc, s.getUserAttributes().get("state"), new Object[0]);
            }
        } else {
            this.wsi.handleRequest(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(Exchange exc, String state, String publicURL, SessionManager.Session session) throws Exception {
        String path = this.uriFactory.create(exc.getDestinations().get(0)).getPath();
        if (path == null) {
            return false;
        }
        if (path.endsWith("/oauth2callback")) {
            try {
                HashMap<String, String> json;
                Response response;
                String code;
                Map<String, String> params = URLParamUtil.getParams(this.uriFactory, exc);
                String state2 = params.get("state");
                if (state2 == null) {
                    throw new RuntimeException("No CSRF token.");
                }
                Map<String, String> param = URLParamUtil.parseQueryString(state2);
                if (param == null || !param.containsKey("security_token")) {
                    throw new RuntimeException("No CSRF token.");
                }
                boolean csrfMatch = false;
                for (String state3 : this.stateToOriginalUrl.keySet()) {
                    if (!param.get("security_token").equals(state3)) continue;
                    csrfMatch = true;
                }
                if (!csrfMatch) {
                    throw new RuntimeException("CSRF token mismatch.");
                }
                Exchange originalRequest = this.stateToOriginalUrl.get(param.get("security_token"));
                String url = originalRequest.getRequest().getUri();
                if (url == null) {
                    url = "/";
                }
                this.stateToOriginalUrl.remove(state2);
                if (log.isDebugEnabled()) {
                    log.debug("CSRF token match.");
                }
                if ((code = params.get("code")) == null) {
                    throw new RuntimeException("No code received.");
                }
                Exchange e = new Request.Builder().post(this.auth.getTokenEndpoint()).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").header("User-Agent", Constants.USERAGENT).body("code=" + code + "&client_id=" + this.auth.getClientId() + "&client_secret=" + this.auth.getClientSecret() + "&redirect_uri=" + publicURL + "oauth2callback&grant_type=authorization_code").buildExchange();
                LogInterceptor logi = null;
                if (log.isDebugEnabled()) {
                    logi = new LogInterceptor();
                    logi.setHeaderOnly(false);
                    logi.handleRequest(e);
                }
                if ((response = this.auth.doRequest(e)).getStatusCode() != 200) {
                    response.getBody().read();
                    throw new RuntimeException("Authentication server returned " + response.getStatusCode() + ".");
                }
                if (log.isDebugEnabled()) {
                    logi.handleResponse(e);
                }
                if (!(json = Util.parseSimpleJSONResponse(response)).containsKey("access_token")) {
                    throw new RuntimeException("No access_token received.");
                }
                String token = json.get("access_token");
                OAuth2AnswerParameters oauth2Answer = new OAuth2AnswerParameters();
                SessionManager.Session session2 = session;
                synchronized (session2) {
                    session.getUserAttributes().put("access_token", token);
                }
                oauth2Answer.setAccessToken(token);
                oauth2Answer.setTokenType(json.get("token_type"));
                oauth2Answer.setExpiration(json.get("expires_in"));
                oauth2Answer.setRefreshToken(json.get("refresh_token"));
                oauth2Answer.setReceivedAt(LocalDateTime.now());
                if (json.containsKey("id_token")) {
                    if (this.idTokenIsValid(json.get("id_token"))) {
                        oauth2Answer.setIdToken(json.get("id_token"));
                    } else {
                        oauth2Answer.setIdToken("INVALID");
                    }
                }
                this.validTokens.put((Object)token, (Object)true);
                Exchange e2 = new Request.Builder().get(this.auth.getUserInfoEndpoint()).header("Authorization", json.get("token_type") + " " + token).header("User-Agent", Constants.USERAGENT).header("Accept", "application/json").buildExchange();
                if (log.isDebugEnabled()) {
                    logi.setHeaderOnly(false);
                    logi.handleRequest(e2);
                }
                Response response2 = this.auth.doRequest(e2);
                if (log.isDebugEnabled()) {
                    logi.handleResponse(e2);
                }
                if (response2.getStatusCode() != 200) {
                    this.statistics.accessTokenInvalid();
                    throw new RuntimeException("User data could not be retrieved.");
                }
                this.statistics.accessTokenValid();
                HashMap<String, String> json2 = Util.parseSimpleJSONResponse(response2);
                oauth2Answer.setUserinfo(json2);
                session.getUserAttributes().put(OAUTH2_ANSWER, oauth2Answer.serialize());
                this.processUserInfo(json2, session);
                this.doRedirect(exc, originalRequest);
                return true;
            }
            catch (Exception e) {
                exc.setResponse(Response.badRequest().body(e.getMessage()).build());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRedirect(Exchange exc, Exchange originalRequest) {
        if (exc.getRequest().getMethod().equals("GET")) {
            exc.setResponse(Response.redirect(originalRequest.getRequestURI(), false).build());
        } else {
            String oa2redirect = new BigInteger(130, new SecureRandom()).toString(32);
            Cache<String, Exchange> cache = this.stateToRedirect;
            synchronized (cache) {
                this.stateToRedirect.put((Object)oa2redirect, (Object)originalRequest);
            }
            String delimiter = originalRequest.getRequestURI().contains("?") ? "&" : "?";
            exc.setResponse(Response.redirect(originalRequest.getRequestURI() + delimiter + OA2REDIRECT + "=" + oa2redirect, false).build());
        }
    }

    private void doOriginalRequest(Exchange exc, Exchange originalRequest) throws Exception {
        originalRequest.getRequest().getHeader().add("Cookie", exc.getRequest().getHeader().getFirstValue("Cookie"));
        originalRequest.getDestinations().clear();
        String xForwardedProto = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Proto");
        String xForwardedHost = originalRequest.getRequest().getHeader().getFirstValue("X-Forwarded-Host");
        String originalRequestUri = originalRequest.getOriginalRequestUri();
        originalRequest.getDestinations().add(xForwardedProto + "://" + xForwardedHost + originalRequestUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUserInfo(Map<String, String> userInfo, SessionManager.Session session) {
        if (!userInfo.containsKey(this.auth.getSubject())) {
            throw new RuntimeException("User object does not contain " + this.auth.getSubject() + " key.");
        }
        Map<String, String> userAttributes = session.getUserAttributes();
        String userIdPropertyFixed = this.auth.getSubject().substring(0, 1).toUpperCase() + this.auth.getSubject().substring(1);
        Map<String, String> map = userAttributes;
        synchronized (map) {
            userAttributes.put("headerX-Authenticated-" + userIdPropertyFixed, userInfo.get(this.auth.getSubject()));
        }
        session.authorize();
    }

    private boolean idTokenIsValid(String idToken) throws Exception {
        try {
            JwtGenerator.getClaimsFromSignedIdToken(idToken, this.getAuthService().getIssuer(), this.getAuthService().getClientId(), this.getAuthService().getJwksEndpoint(), this.auth.getHttpClient());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getShortDescription() {
        return "Client of the oauth2 authentication process.\n" + this.statistics.toString();
    }
}

