/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;

public class WellknownFile {
    private static final String ISSUER = "issuer";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String USERINFO_ENDPOINT = "userinfo_endpoint";
    private static final String REVOCATION_ENDPOINT = "revocation_endpoint";
    private static final String JWKS_URI = "jwks_uri";
    private static final String RESPONSE_TYPES_SUPPORTED = "response_types_supported";
    private static final String SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
    private static final String ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = "id_token_signing_alg_values_supported";
    private static final String SCOPES_SUPPORTED = "scopes_supported";
    private static final String TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = "token_endpoint_auth_methods_supported";
    private static final String CLAIMS_SUPPORTED = "claims_supported";
    private String wellknown;
    private OAuth2AuthorizationServerInterceptor oasi;
    private ResolverMap resolver;
    private ReusableJsonGenerator reusableJsonGen = new ReusableJsonGenerator();
    private JsonGenerator jsonGen;
    private String authorizationEndpoint;
    private String issuer;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String revocationEndpoint;
    private String jwksUri;
    private String supportedResponseTypes;
    private String supportedSubjectType;
    private String supportedIdTokenSigningAlgValues;
    private String supportedScopes;
    private String supportedTokenEndpointAuthMethods;
    private String supportedClaims;

    public void init(Router router, OAuth2AuthorizationServerInterceptor oasi) throws IOException {
        this.resolver = router.getResolverMap();
        this.oasi = oasi;
        this.getValuesFromOasi();
        this.writeWellknown();
    }

    public void init(Router router) throws IOException {
        this.init(router, null);
    }

    private String getOauth2Issuer() {
        return this.oasi.getIssuer();
    }

    private String baseOauth2Url() {
        return ResolverMap.combine(this.getOauth2Issuer(), "/oauth2/");
    }

    private void getValuesFromOasi() throws UnsupportedEncodingException {
        if (this.oasi == null) {
            return;
        }
        this.setIssuer(this.getOauth2Issuer());
        this.setAuthorizationEndpoint(this.baseOauth2Url() + "auth");
        this.setTokenEndpoint(this.baseOauth2Url() + "token");
        this.setUserinfoEndpoint(this.baseOauth2Url() + "userinfo");
        this.setRevocationEndpoint(this.baseOauth2Url() + "revoke");
        this.setJwksUri(this.baseOauth2Url() + "certs");
        this.setSupportedResponseTypes(this.oasi.getSupportedAuthorizationGrants());
        this.setSupportedSubjectType("public");
        this.setSupportedIdTokenSigningAlgValues("RS256");
        this.setSupportedScopes(this.getSupportedOasiScopes());
        this.setSupportedTokenEndpointAuthMethods("client_secret_post");
        this.setSupportedClaims(this.getSupportedOasiClaims());
    }

    private String getSupportedOasiClaims() {
        return this.oasi.getClaimList().getSupportedClaimsAsString();
    }

    private String getSupportedOasiScopes() {
        return this.oasi.getClaimList().getSupportedScopes();
    }

    private void writeWellknown() throws IOException {
        this.jsonGen = this.reusableJsonGen.resetAndGet();
        this.jsonGen.writeStartObject();
        this.writeIssuer();
        this.writeAuthorizationEndpoint();
        this.writeTokenEndpoint();
        this.writeUserinfoEndpoint();
        this.writeRevocationEndpoint();
        this.writeJwksUri();
        this.writeSupportedResponseTypes();
        this.writeSupportedSubjectTypes();
        this.writeSupportedIdTokenSigningAlgValues();
        this.writeSupportedScopes();
        this.writeSupportedTokenEndpointAuthMethods();
        this.writeSupportedClaims();
        this.jsonGen.writeEndObject();
        this.setWellknown(this.reusableJsonGen.getJson());
    }

    private void writeSupportedClaims() throws IOException {
        this.stringEnumToJson(CLAIMS_SUPPORTED, this.getSupportedClaims().split(" "));
    }

    private void writeSupportedTokenEndpointAuthMethods() throws IOException {
        this.stringEnumToJson(TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED, this.getSupportedTokenEndpointAuthMethods().split(" "));
    }

    private void writeSupportedScopes() throws IOException {
        this.stringEnumToJson(SCOPES_SUPPORTED, this.getSupportedScopes().split(" "));
    }

    private void writeSupportedIdTokenSigningAlgValues() throws IOException {
        this.stringEnumToJson(ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED, this.getSupportedIdTokenSigningAlgValues().split(" "));
    }

    private void writeSupportedSubjectTypes() throws IOException {
        this.stringEnumToJson(SUBJECT_TYPES_SUPPORTED, this.getSupportedSubjectType().split(" "));
    }

    private void stringEnumToJson(String name, String ... enumeration) throws IOException {
        this.jsonGen.writeArrayFieldStart(name);
        for (String value : enumeration) {
            this.jsonGen.writeString(OAuth2Util.urldecode(value));
        }
        this.jsonGen.writeEndArray();
    }

    private void writeSupportedResponseTypes() throws IOException {
        this.stringEnumToJson(RESPONSE_TYPES_SUPPORTED, this.getSupportedResponseTypes().split(" "));
    }

    private void writeJwksUri() throws IOException {
        this.writeSingleJsonField(JWKS_URI, this.getJwksUri());
    }

    private void writeSingleJsonField(String name, String value) throws IOException {
        this.jsonGen.writeObjectField(name, (Object)value);
    }

    private void writeRevocationEndpoint() throws IOException {
        this.writeSingleJsonField(REVOCATION_ENDPOINT, this.getRevocationEndpoint());
    }

    private void writeUserinfoEndpoint() throws IOException {
        this.writeSingleJsonField(USERINFO_ENDPOINT, this.getUserinfoEndpoint());
    }

    private void writeTokenEndpoint() throws IOException {
        this.writeSingleJsonField(TOKEN_ENDPOINT, this.getTokenEndpoint());
    }

    private void writeAuthorizationEndpoint() throws IOException {
        this.writeSingleJsonField(AUTHORIZATION_ENDPOINT, this.getAuthorizationEndpoint());
    }

    private void writeIssuer() throws IOException {
        this.writeSingleJsonField(ISSUER, this.getIssuer());
    }

    protected String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    protected void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    protected String getIssuer() {
        return this.issuer;
    }

    protected void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    protected String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    protected void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    protected String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    protected void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    protected String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    protected void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    protected String getJwksUri() {
        return this.jwksUri;
    }

    protected void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    protected String getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    protected void setSupportedResponseTypes(HashSet<String> supportedResponseTypes) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (String resp : supportedResponseTypes) {
            builder.append(" ").append(OAuth2Util.urlencode(resp));
        }
        this.setSupportedResponseTypes(builder.toString().trim());
    }

    protected void setSupportedResponseTypes(String supportedResponseTypes) {
        this.supportedResponseTypes = supportedResponseTypes;
    }

    protected String getSupportedSubjectType() {
        return this.supportedSubjectType;
    }

    protected void setSupportedSubjectType(String supportedSubjectType) {
        this.supportedSubjectType = supportedSubjectType;
    }

    protected String getSupportedIdTokenSigningAlgValues() {
        return this.supportedIdTokenSigningAlgValues;
    }

    protected void setSupportedIdTokenSigningAlgValues(String supportedIdTokenSigningAlgValues) {
        this.supportedIdTokenSigningAlgValues = supportedIdTokenSigningAlgValues;
    }

    protected String getSupportedScopes() {
        return this.supportedScopes;
    }

    protected void setSupportedScopes(String supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    protected String getSupportedTokenEndpointAuthMethods() {
        return this.supportedTokenEndpointAuthMethods;
    }

    protected void setSupportedTokenEndpointAuthMethods(String supportedTokenEndpointAuthMethods) {
        this.supportedTokenEndpointAuthMethods = supportedTokenEndpointAuthMethods;
    }

    protected String getSupportedClaims() {
        return this.supportedClaims;
    }

    protected void setSupportedClaims(String supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public String getWellknown() {
        return this.wellknown;
    }

    public void setWellknown(String wellknown) {
        this.wellknown = wellknown;
    }
}

