/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.flows;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.flows.OAuth2Flow;
import com.predic8.membrane.core.interceptor.oauth2.flows.TokenFlow;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.tokengenerators.JwtGenerator;
import java.util.ArrayList;
import org.jose4j.lang.JoseException;

public class IdTokenTokenFlow
extends OAuth2Flow {
    Client client = null;
    String username = null;
    String token = null;
    String idToken = null;
    TokenFlow tokenFlow = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdTokenTokenFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc, SessionManager.Session s) throws JoseException {
        super(authServer, exc, s);
        SessionManager.Session session = s;
        synchronized (session) {
            this.client = authServer.getClientList().getClient(this.session.getUserAttributes().get("client_id"));
            this.username = s.getUserName();
        }
        this.tokenFlow = new TokenFlow(authServer, exc, this.session);
        this.token = this.tokenFlow.generateAccessToken(this.client);
        this.idToken = this.createSignedIdToken();
    }

    @Override
    public Outcome getResponse() throws Exception {
        return this.respondWithTokensAndRedirect();
    }

    private Outcome respondWithTokensAndRedirect() {
        this.tokenFlow.getResponse();
        this.addIdTokenToRedirect();
        return Outcome.RETURN;
    }

    private void addIdTokenToRedirect() {
        this.exc.getResponse().getHeader().setValue("Location", this.exc.getResponse().getHeader().getFirstValue("Location") + "&id_token=" + this.idToken);
    }

    private JwtGenerator.Claim[] getValidIdTokenClaims() {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), this.session.getUserAttributes().get("claims"));
        ArrayList<JwtGenerator.Claim> claims = new ArrayList<JwtGenerator.Claim>();
        if (cp.hasClaims()) {
            for (String claim : cp.getIdTokenClaims()) {
                claims.add(new JwtGenerator.Claim(claim, this.session.getUserAttributes().get(ClaimRenamer.convert(claim))));
            }
        }
        return claims.toArray(new JwtGenerator.Claim[0]);
    }

    private String createSignedIdToken() throws JoseException {
        return this.getSignedIdToken(this.getValidIdTokenClaims());
    }

    private String getSignedIdToken(JwtGenerator.Claim ... claims) throws JoseException {
        return this.authServer.getJwtGenerator().getSignedIdToken(this.authServer.getIssuer(), this.username, this.client.getClientId(), 600, claims);
    }
}

