/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.interceptor.DispatchingInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.rest.SOAPRESTHelper;
import com.predic8.membrane.core.interceptor.rest.XML2HTTP;
import com.predic8.membrane.core.interceptor.soap.SoapOperationExtractor;
import javax.xml.transform.stream.StreamSource;

@MCElement(name="soap2Rest")
public class SOAP2RESTInterceptor
extends SOAPRESTHelper {
    private String requestXSLT;
    private String responseXSLT;
    private SoapOperationExtractor soe = new SoapOperationExtractor();
    private DispatchingInterceptor di = new DispatchingInterceptor();

    public SOAP2RESTInterceptor() {
        this.name = "SOAP 2 REST Gateway";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        this.soe.handleRequest(exc);
        this.transformAndReplaceBody(exc.getRequest(), this.requestXSLT, new StreamSource(exc.getRequest().getBodyAsStreamDecoded()), exc.getStringProperties());
        Header header = exc.getRequest().getHeader();
        header.removeFields("Content-Type");
        header.setContentType("text/xml;charset=UTF-8");
        XML2HTTP.unwrapMessageIfNecessary(exc.getRequest());
        exc.getDestinations().clear();
        this.di.handleRequest(exc);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        this.transformAndReplaceBody(exc.getResponse(), this.responseXSLT, this.getExchangeXMLSource(exc), exc.getStringProperties());
        return Outcome.CONTINUE;
    }

    @Override
    public String getShortDescription() {
        return "Transforms SOAP messages into REST requests and vice versa.";
    }

    public String getRequestXSLT() {
        return this.requestXSLT;
    }

    @MCAttribute
    public void setRequestXSLT(String requestXSLT) {
        this.requestXSLT = requestXSLT;
    }

    public String getResponseXSLT() {
        return this.responseXSLT;
    }

    @MCAttribute
    public void setResponseXSLT(String responseXSLT) {
        this.responseXSLT = responseXSLT;
    }
}

