/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML2HTTP {
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unwrapMessageIfNecessary(Message message) {
        if ("text/xml;charset=UTF-8".equals(message.getHeader().getContentType())) {
            try {
                XMLEventReader parser;
                if (message.getBody().getLength() == 0) {
                    return;
                }
                XMLInputFactory xMLInputFactory = xmlInputFactory;
                synchronized (xMLInputFactory) {
                    parser = xmlInputFactory.createXMLEventReader(message.getBodyAsStreamDecoded(), message.getCharset());
                }
                int state = 0;
                boolean keepSourceHeaders = false;
                boolean foundHeaders = false;
                boolean foundBody = false;
                block11: while (parser.hasNext()) {
                    XMLEvent event = parser.nextEvent();
                    switch (state) {
                        case 0: {
                            Request req;
                            if (!event.isStartElement()) break;
                            QName name = event.asStartElement().getName();
                            if ("http://membrane-soa.org/schemas/http/v1/".equals(name.getNamespaceURI())) {
                                state = 1;
                                if (!"request".equals(name.getLocalPart())) continue block11;
                                req = (Request)message;
                                req.setMethod(XML2HTTP.requireAttribute(event.asStartElement(), "method"));
                                String httpVersion = XML2HTTP.getAttribute(event.asStartElement(), "http-version");
                                if (httpVersion == null) {
                                    httpVersion = "1.1";
                                }
                                req.setVersion(httpVersion);
                                break;
                            }
                            return;
                        }
                        case 1: {
                            Request req;
                            if (!event.isStartElement()) break;
                            String localName = event.asStartElement().getName().getLocalPart();
                            if ("status".equals(localName)) {
                                Response res = (Response)message;
                                res.setStatusCode(Integer.parseInt(XML2HTTP.requireAttribute(event.asStartElement(), "code")));
                                res.setStatusMessage(XML2HTTP.slurpCharacterData(parser, event.asStartElement()));
                            }
                            if ("uri".equals(localName)) {
                                req = (Request)message;
                                req.setUri(XML2HTTP.requireAttribute(event.asStartElement(), "value"));
                                XML2HTTP.slurpXMLData(parser, event.asStartElement());
                            }
                            if ("headers".equals(localName)) {
                                foundHeaders = true;
                                keepSourceHeaders = "true".equals(XML2HTTP.getAttribute(event.asStartElement(), "keepSourceHeaders"));
                            }
                            if ("header".equals(localName)) {
                                boolean remove;
                                String key = XML2HTTP.requireAttribute(event.asStartElement(), "name");
                                boolean bl = remove = XML2HTTP.getAttribute(event.asStartElement(), "remove") != null;
                                if (remove && !keepSourceHeaders) {
                                    throw new XML2HTTPException("<headers keepSourceHeaders=\"false\"><header name=\"...\" remove=\"true\"> does not make sense.");
                                }
                                message.getHeader().removeFields(key);
                                if (!remove) {
                                    message.getHeader().add(key, XML2HTTP.slurpCharacterData(parser, event.asStartElement()));
                                }
                            }
                            if (!"body".equals(localName)) break;
                            foundBody = true;
                            String type = XML2HTTP.requireAttribute(event.asStartElement(), "type");
                            if ("plain".equals(type)) {
                                message.setBodyContent(XML2HTTP.slurpCharacterData(parser, event.asStartElement()).getBytes(Constants.UTF_8_CHARSET));
                                break;
                            }
                            if ("xml".equals(type)) {
                                message.setBodyContent(XML2HTTP.slurpXMLData(parser, event.asStartElement()).getBytes(Constants.UTF_8_CHARSET));
                                break;
                            }
                            throw new XML2HTTPException("XML-HTTP doc body type '" + type + "' is not supported (only 'plain' or 'xml').");
                        }
                    }
                }
                if (!foundHeaders && !keepSourceHeaders) {
                    message.getHeader().clear();
                }
                if (!foundBody) {
                    message.setBodyContent(new byte[0]);
                }
            }
            catch (XMLStreamException e) {
                log.error("", (Throwable)e);
            }
            catch (XML2HTTPException e) {
                log.error("", (Throwable)e);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private static String slurpCharacterData(XMLEventReader parser, StartElement sevent) throws XMLStreamException, XML2HTTPException {
        String name = sevent.getName().getLocalPart();
        StringBuilder value = new StringBuilder();
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (event.isCharacters()) {
                value.append(event.asCharacters().getData());
                continue;
            }
            if (event.isEndElement()) break;
            throw new XML2HTTPException("XML-HTTP doc <" + name + "> element contains non-character data.");
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String slurpXMLData(XMLEventReader parser, StartElement sevent) throws XML2HTTPException, XMLStreamException {
        StringWriter bodyStringWriter = new StringWriter();
        XMLEventWriter bodyWriter = null;
        int depth = 0;
        XMLOutputFactory xMLOutputFactory = xmlOutputFactory;
        synchronized (xMLOutputFactory) {
            bodyWriter = xmlOutputFactory.createXMLEventWriter(bodyStringWriter);
        }
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (event.isEndElement() && depth == 0) {
                bodyWriter.flush();
                return bodyStringWriter.toString();
            }
            bodyWriter.add(event);
            if (event.isStartElement()) {
                ++depth;
                continue;
            }
            if (!event.isEndElement()) continue;
            --depth;
        }
        throw new XML2HTTPException("Early end of file while reading inner XML document.");
    }

    private static String requireAttribute(StartElement element, String name) throws XML2HTTPException {
        Attribute attribute = element.getAttributeByName(new QName(name));
        if (attribute == null) {
            throw new XML2HTTPException("XML-HTTP doc <" + element.getName().getLocalPart() + "> element does not have @" + name + " attribute.");
        }
        return attribute.getValue();
    }

    private static String getAttribute(StartElement element, String name) throws XML2HTTPException {
        Attribute attribute = element.getAttributeByName(new QName(name));
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        log = LoggerFactory.getLogger(XML2HTTP.class);
    }

    private static class XML2HTTPException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XML2HTTPException(String message) {
            super("REST2SOAP: " + message);
        }
    }
}

