/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.IValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchemaValidatorErrorHandler;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.schema.Schema;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLSchemaValidator
implements IValidator {
    private static Logger log = LoggerFactory.getLogger((String)AbstractXMLSchemaValidator.class.getName());
    private final ArrayBlockingQueue<List<Validator>> validators;
    protected final XOPReconstitutor xopr;
    protected final String location;
    protected final ResolverMap resourceResolver;
    protected final ValidatorInterceptor.FailureHandler failureHandler;
    private final boolean skipFaults;
    protected final AtomicLong valid = new AtomicLong();
    protected final AtomicLong invalid = new AtomicLong();

    public AbstractXMLSchemaValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler) throws Exception {
        this(resourceResolver, location, failureHandler, false);
    }

    public AbstractXMLSchemaValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler, boolean skipFaults) throws Exception {
        this.location = location;
        this.resourceResolver = resourceResolver;
        this.failureHandler = failureHandler;
        this.skipFaults = skipFaults;
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.validators = new ArrayBlockingQueue(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            this.validators.add(this.createValidators());
        }
        this.xopr = new XOPReconstitutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome validateMessage(Exchange exc, Message msg, String source) throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        String preliminaryError = this.getPreliminaryError(this.xopr, msg);
        if (preliminaryError == null) {
            List<Validator> vals = this.validators.take();
            try {
                for (Validator validator : vals) {
                    SchemaValidatorErrorHandler handler = (SchemaValidatorErrorHandler)validator.getErrorHandler();
                    try {
                        validator.validate(this.getMessageBody(this.xopr.reconstituteIfNecessary(msg)));
                        if (handler.noErrors()) {
                            this.valid.incrementAndGet();
                            Outcome outcome = Outcome.CONTINUE;
                            return outcome;
                        }
                        exceptions.add(handler.getException());
                    }
                    finally {
                        handler.reset();
                    }
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                this.validators.put(vals);
            }
        } else {
            exceptions.add(new Exception(preliminaryError));
        }
        if (this.skipFaults && this.isFault(msg)) {
            this.valid.incrementAndGet();
            return Outcome.CONTINUE;
        }
        if (this.failureHandler == ValidatorInterceptor.FailureHandler.VOID) {
            exc.setProperty("error", this.getErrorMsg(exceptions));
        } else if (this.failureHandler != null) {
            this.failureHandler.handleFailure(this.getErrorMsg(exceptions), exc);
            exc.setResponse(this.createErrorResponse("validation error"));
        } else {
            exc.setResponse(this.createErrorResponse(this.getErrorMsg(exceptions)));
            exc.getResponse().getHeader().add("X-Validation-Error-Source", source);
        }
        this.invalid.incrementAndGet();
        return Outcome.ABORT;
    }

    protected List<Validator> createValidators() throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Schema schema : this.getSchemas()) {
            log.debug("Creating validator for schema: " + schema);
            StreamSource ss = new StreamSource(new StringReader(schema.getAsString()));
            ss.setSystemId(this.location);
            sf.setResourceResolver(this.resourceResolver.toLSResourceResolver());
            Validator validator = sf.newSchema(ss).newValidator();
            validator.setResourceResolver(this.resourceResolver.toLSResourceResolver());
            validator.setErrorHandler(new SchemaValidatorErrorHandler());
            validators.add(validator);
        }
        return validators;
    }

    private String getErrorMsg(List<Exception> excs) {
        StringBuilder buf = new StringBuilder();
        buf.append("Validation failed: ");
        for (Exception e : excs) {
            buf.append(e);
            buf.append("; ");
        }
        return buf.toString();
    }

    @Override
    public long getValid() {
        return this.valid.get();
    }

    @Override
    public long getInvalid() {
        return this.invalid.get();
    }

    protected abstract List<Schema> getSchemas();

    protected abstract Source getMessageBody(InputStream var1) throws Exception;

    protected abstract Response createErrorResponse(String var1);

    protected abstract boolean isFault(Message var1);

    protected abstract String getPreliminaryError(XOPReconstitutor var1, Message var2);
}

