/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilter;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="soapStackTraceFilter")
public class SOAPStackTraceFilterInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SOAPStackTraceFilterInterceptor.class);
    private static final String XPATH = "//*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='stackTrace' or local-name()='stacktrace'] | //*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='faultstring' and contains(., '.java:')] | //*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='exception' and namespace-uri()='http://jax-ws.dev.java.net/']/message |//*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//detail/Exception";
    private final XMLContentFilter xmlContentFilter = new XMLContentFilter("//*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='stackTrace' or local-name()='stacktrace'] | //*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='faultstring' and contains(., '.java:')] | //*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//*[local-name()='exception' and namespace-uri()='http://jax-ws.dev.java.net/']/message |//*[local-name()='Fault' and namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/']//detail/Exception");

    public SOAPStackTraceFilterInterceptor() throws XPathExpressionException {
        this.setDisplayName("SOAP StackTrace Filter");
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getResponse());
    }

    private Outcome handleMessage(Exchange exc, Message message) {
        try {
            this.xmlContentFilter.removeMatchingElements(message);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            LOG.error("soapStackTraceFilter error", (Throwable)e);
            exc.setResponse(Response.internalServerError("soapStackTraceFilter error. See log for details.").build());
            return Outcome.ABORT;
        }
    }
}

