/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.groovy;

import com.google.common.base.Function;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;

public class GroovyLanguageSupport
extends LanguageSupport {
    private static final GroovyShell shell = new GroovyShell();

    @Override
    public Function<Map<String, Object>, Boolean> compileExpression(Router router, String src) {
        return new GroovyScriptExecutorPool<Boolean>(router, this.addImports(src)){

            public Boolean apply(Map<String, Object> parameters) {
                Object result = this.execute(parameters);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return false;
            }
        };
    }

    @Override
    public Function<Map<String, Object>, Object> compileScript(Router router, String script) {
        return new GroovyScriptExecutorPool<Object>(router, this.addImports(script)){

            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private String addImports(String src) {
        return "import static com.predic8.membrane.core.interceptor.Outcome.*\nimport com.predic8.membrane.core.http.*\n" + src;
    }

    private abstract class GroovyScriptExecutorPool<R>
    extends ScriptExecutorPool<Script, R> {
        private final String groovyCode;

        private GroovyScriptExecutorPool(Router router, String expression) {
            this.groovyCode = expression;
            this.init(router);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Script createOneScript() {
            GroovyShell groovyShell = shell;
            synchronized (groovyShell) {
                return shell.parse(this.groovyCode);
            }
        }

        @Override
        protected Object invoke(Script script, Map<String, Object> parameters) {
            Binding b = new Binding();
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                b.setVariable(parameter.getKey(), parameter.getValue());
            }
            script.setBinding(b);
            return script.run();
        }
    }
}

