/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.resolver;

import com.google.common.base.Objects;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.cloud.etcd.EtcdResolver;
import com.predic8.membrane.core.resolver.ClasspathSchemaResolver;
import com.predic8.membrane.core.resolver.FileSchemaResolver;
import com.predic8.membrane.core.resolver.HTTPSchemaResolver;
import com.predic8.membrane.core.resolver.Resolver;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.LSInputImpl;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import com.predic8.xml.util.ExternalResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.List;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@MCElement(name="resolverMap")
public class ResolverMap
implements Cloneable,
Resolver {
    private EtcdResolver etcdResolver;
    int count = 0;
    private String[] schemas;
    private SchemaResolver[] resolvers;

    public static String combine(String ... locations) {
        if (locations.length < 2) {
            throw new InvalidParameterException();
        }
        if (locations.length > 2) {
            String[] l = new String[locations.length - 1];
            System.arraycopy(locations, 0, l, 0, locations.length - 1);
            return ResolverMap.combine(ResolverMap.combine(l), locations[locations.length - 1]);
        }
        String parent = locations[0];
        String relativeChild = locations[1];
        if (relativeChild.contains(":/") || relativeChild.contains(":\\") || parent == null || parent.length() == 0) {
            return relativeChild;
        }
        if (parent.startsWith("file://")) {
            if (relativeChild.startsWith("\\") || relativeChild.startsWith("/")) {
                return "file://" + new File(relativeChild).getAbsolutePath();
            }
            File parentFile = new File(FileSchemaResolver.normalize(parent));
            if (!parent.endsWith("/") && !parent.endsWith("\\")) {
                parentFile = parentFile.getParentFile();
            }
            String res = "file://" + new File(parentFile, relativeChild).getAbsolutePath();
            if (relativeChild.endsWith("/") || relativeChild.endsWith("\\")) {
                res = res + "/";
            }
            return res;
        }
        if (parent.contains(":/")) {
            try {
                return new URI(parent).resolve(relativeChild.replaceAll("\\\\", "/")).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (parent.startsWith("/")) {
            try {
                return new URI("file:" + parent).resolve(relativeChild).toString().substring(5);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        File parentFile = new File(parent);
        if (!parent.endsWith("/") && !parent.endsWith("\\")) {
            parentFile = parentFile.getParentFile();
        }
        return new File(parentFile, relativeChild).getAbsolutePath();
    }

    public ResolverMap() {
        this.schemas = new String[10];
        this.resolvers = new SchemaResolver[10];
        this.addSchemaResolver(new ClasspathSchemaResolver());
        this.addSchemaResolver(new HTTPSchemaResolver());
        this.addSchemaResolver(new FileSchemaResolver());
    }

    private ResolverMap(ResolverMap other) {
        this.count = other.count;
        this.schemas = new String[other.schemas.length];
        this.resolvers = new SchemaResolver[other.resolvers.length];
        System.arraycopy(other.schemas, 0, this.schemas, 0, this.count);
        System.arraycopy(other.resolvers, 0, this.resolvers, 0, this.count);
    }

    public ResolverMap clone() {
        return new ResolverMap(this);
    }

    public void addSchemaResolver(SchemaResolver sr) {
        for (String schema : sr.getSchemas()) {
            this.addSchemaResolver(schema == null ? null : schema + ":", sr);
        }
    }

    private void addSchemaResolver(String schema, SchemaResolver resolver) {
        int newIndex;
        for (int i = 0; i < this.count; ++i) {
            if (!Objects.equal((Object)this.schemas[i], (Object)schema)) continue;
            this.resolvers[i] = resolver;
            return;
        }
        if (++this.count > this.schemas.length) {
            String[] schemas2 = new String[this.schemas.length * 2];
            System.arraycopy(this.schemas, 0, schemas2, 0, this.schemas.length);
            this.schemas = schemas2;
            SchemaResolver[] resolvers2 = new SchemaResolver[this.resolvers.length * 2];
            System.arraycopy(this.resolvers, 0, resolvers2, 0, this.resolvers.length);
            this.resolvers = resolvers2;
        }
        if ((newIndex = this.count - 1) > 0 && this.schemas[newIndex - 1] == null) {
            this.schemas[newIndex] = this.schemas[newIndex - 1];
            this.resolvers[newIndex] = this.resolvers[newIndex - 1];
            --newIndex;
        }
        this.schemas[newIndex] = schema;
        this.resolvers[newIndex] = resolver;
    }

    private SchemaResolver getSchemaResolver(String uri) {
        for (int i = 0; i < this.count; ++i) {
            if (this.schemas[i] == null) {
                return this.resolvers[i];
            }
            if (!uri.startsWith(this.schemas[i])) continue;
            return this.resolvers[i];
        }
        throw new RuntimeException("No SchemaResolver defined for " + uri);
    }

    @Override
    public long getTimestamp(String uri) throws FileNotFoundException {
        return this.getSchemaResolver(uri).getTimestamp(uri);
    }

    @Override
    public InputStream resolve(String uri) throws ResourceRetrievalException {
        return this.getSchemaResolver(uri).resolve(uri);
    }

    @Override
    public void observeChange(String uri, Consumer<InputStream> consumer) throws ResourceRetrievalException {
        this.getSchemaResolver(uri).observeChange(uri, consumer);
    }

    @Override
    public List<String> getChildren(String uri) throws FileNotFoundException {
        return this.getSchemaResolver(uri).getChildren(uri);
    }

    public HTTPSchemaResolver getHTTPSchemaResolver() {
        return (HTTPSchemaResolver)this.getSchemaResolver("http:");
    }

    public SchemaResolver getFileSchemaResolver() {
        return this.getSchemaResolver("file:");
    }

    public LSResourceResolver toLSResourceResolver() {
        return new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                if (systemId == null) {
                    return null;
                }
                try {
                    if (!systemId.contains("://")) {
                        systemId = new URI(baseURI).resolve(systemId).toString();
                    }
                    return new LSInputImpl(publicId, systemId, ResolverMap.this.resolve(systemId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public ExternalResolverConverter toExternalResolver() {
        return new ExternalResolverConverter();
    }

    public EtcdResolver getEtcdResolver() {
        return this.etcdResolver;
    }

    @MCChildElement(order=0)
    public void setEtcdResolver(EtcdResolver etcdResolver) {
        this.etcdResolver = etcdResolver;
        this.addSchemaResolver(etcdResolver);
    }

    public class ExternalResolverConverter {
        public ExternalResolver toExternalResolver() {
            return new ExternalResolver(){

                public InputStream resolveAsFile(String filename, String baseDir) {
                    try {
                        if (baseDir != null) {
                            return ResolverMap.this.resolve(ResolverMap.combine(baseDir, filename));
                        }
                        return ResolverMap.this.resolve(filename);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                protected InputStream resolveViaHttp(Object url) {
                    try {
                        String url2 = (String)url;
                        int q = url2.indexOf(63);
                        url2 = q == -1 ? url2.replaceAll("/[^/]+/\\.\\./", "/") : url2.substring(0, q).replaceAll("/[^/]+/\\.\\./", "/") + url2.substring(q);
                        return ResolverMap.this.getSchemaResolver(url2).resolve(url2);
                    }
                    catch (ResourceRetrievalException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }
}

