/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.stats;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.rules.StatisticCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RuleStatisticCollector {
    private ConcurrentHashMap<Integer, StatisticCollector> statusCodes = new ConcurrentHashMap();

    private StatisticCollector getStatisticCollectorByStatusCode(int code) {
        StatisticCollector sc = this.statusCodes.get(code);
        if (sc == null) {
            sc = new StatisticCollector(true);
            StatisticCollector sc2 = this.statusCodes.putIfAbsent(code, sc);
            if (sc2 != null) {
                sc = sc2;
            }
        }
        return sc;
    }

    public Map<Integer, StatisticCollector> getStatisticsByStatusCodes() {
        return this.statusCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Exchange exc) {
        StatisticCollector sc;
        StatisticCollector statisticCollector = sc = this.getStatisticCollectorByStatusCode(exc.getResponse().getStatusCode());
        synchronized (statisticCollector) {
            sc.collectFrom(exc);
        }
    }

    public int getCount() {
        int c = 0;
        for (StatisticCollector statisticCollector : this.statusCodes.values()) {
            c += statisticCollector.getCount();
        }
        return c;
    }
}

