/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEndpointListener
extends Thread {
    private static final Logger log = LoggerFactory.getLogger((String)HttpEndpointListener.class.getName());
    public static final byte[] RATE_LIMIT_RESPONSE_MESSAGE = "HTTP/1.1 429\r\nContent-Length: 0\r\n\r\n".getBytes();
    private final ServerSocket serverSocket;
    private final HttpTransport transport;
    private final SSLProvider sslProvider;
    private final ConcurrentHashMap<Socket, Boolean> idleSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<Socket, Boolean> openSockets = new ConcurrentHashMap();
    private final ConcurrentHashMap<InetAddress, ClientInfo> ipConnectionCount = new ConcurrentHashMap();
    private volatile boolean closed;

    public HttpEndpointListener(String ip, int port, HttpTransport transport, SSLProvider sslProvider) throws IOException {
        this.transport = transport;
        this.sslProvider = sslProvider;
        try {
            this.serverSocket = sslProvider != null ? sslProvider.createServerSocket(port, 50, ip != null ? InetAddress.getByName(ip) : null) : new ServerSocket(port, 50, ip != null ? InetAddress.getByName(ip) : null);
            this.setName("Connection Acceptor " + (ip != null ? ip + ":" : ":") + port);
            log.debug("listening at port " + port + (ip != null ? " ip " + ip : ""));
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Collection values = HttpEndpointListener.this.ipConnectionCount.values();
                    for (ClientInfo v : values) {
                        if (v.count.get() > 0 || System.currentTimeMillis() - v.lastUse < 600000L) continue;
                        values.remove(v);
                    }
                }
            }, 60000L, 60000L);
        }
        catch (BindException e) {
            throw new PortOccupiedException(port);
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                int currentConnections;
                Socket socket = this.serverSocket.accept();
                InetAddress remoteIp = this.getRemoteIp(socket);
                ClientInfo connectionCount = this.ipConnectionCount.get(remoteIp);
                if (connectionCount == null) {
                    ClientInfo oldconnectionCount = connectionCount = new ClientInfo();
                    if ((connectionCount = this.ipConnectionCount.putIfAbsent(remoteIp, connectionCount)) == null) {
                        connectionCount = oldconnectionCount;
                    }
                }
                int concurrentConnectionLimitPerIp = this.transport.getConcurrentConnectionLimitPerIp();
                boolean connnectionWithinLimit = true;
                do {
                    if ((currentConnections = connectionCount.get()) < concurrentConnectionLimitPerIp) continue;
                    log.warn(this.constructLogMessage(new StringBuilder(), remoteIp, this.readUpTo1KbOfDataFrom(socket, new byte[1023])));
                    this.writeRateLimitReachedToSource(socket);
                    socket.close();
                    connnectionWithinLimit = false;
                    break;
                } while (!connectionCount.compareAndSet(currentConnections, currentConnections + 1));
                if (!connnectionWithinLimit) continue;
                this.openSockets.put(socket, Boolean.TRUE);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted connection from " + socket.getRemoteSocketAddress());
                    }
                    this.transport.getExecutorService().execute(new HttpServerHandler(socket, this));
                }
                catch (RejectedExecutionException e) {
                    connectionCount.decrementAndGet();
                    this.openSockets.remove(socket);
                    log.error("HttpServerHandler execution rejected. Might be due to a proxies.xml hot deployment in progress or a low value for <transport maxThreadPoolSize=\"...\">.");
                    socket.close();
                }
            }
            catch (SocketException e) {
                String message = e.getMessage();
                if (message != null && (message.endsWith("socket closed") || message.endsWith("Socket closed"))) {
                    log.debug("socket closed.");
                    break;
                }
                log.error("", (Throwable)e);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void closePort() throws IOException {
        this.closed = true;
        if (!this.serverSocket.isClosed()) {
            this.serverSocket.close();
        }
    }

    public boolean closeConnections(boolean onlyIdle) throws IOException {
        if (!this.closed) {
            throw new IllegalStateException("please call closePort() fist.");
        }
        for (Socket s : (onlyIdle ? this.idleSockets : this.openSockets).keySet()) {
            if (s.isClosed()) continue;
            s.close();
        }
        return this.openSockets.isEmpty();
    }

    void setIdleStatus(Socket socket, boolean isIdle) throws IOException {
        if (isIdle) {
            if (this.closed) {
                socket.close();
                throw new SocketException();
            }
            this.idleSockets.put(socket, Boolean.TRUE);
        } else {
            this.idleSockets.remove(socket);
        }
    }

    void setOpenStatus(Socket socket, boolean isOpen) {
        if (isOpen) {
            throw new InvalidParameterException("isOpen");
        }
        this.openSockets.remove(socket);
        InetAddress remoteIp = this.getRemoteIp(socket);
        ClientInfo clientInfo = this.ipConnectionCount.get(remoteIp);
        if (clientInfo != null) {
            AtomicInteger connectionCount = clientInfo.count;
            connectionCount.decrementAndGet();
        }
    }

    public int getNumberOfOpenConnections() {
        return this.openSockets.size();
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public SSLProvider getSslProvider() {
        return this.sslProvider;
    }

    private void writeRateLimitReachedToSource(Socket sourceSocket) throws IOException {
        sourceSocket.getOutputStream().write(RATE_LIMIT_RESPONSE_MESSAGE, 0, RATE_LIMIT_RESPONSE_MESSAGE.length);
        sourceSocket.getOutputStream().flush();
    }

    private String constructLogMessage(StringBuilder sb, InetAddress ip, AbstractMap.SimpleEntry<byte[], Integer> receivedContent) {
        return sb.append("Concurrent connection limit reached for IP: ").append(ip.toString()).append(System.lineSeparator()).append("Received the following content").append(System.lineSeparator()).append("===START===").append(System.lineSeparator()).append(new String(receivedContent.getKey(), 0, (int)receivedContent.getValue())).append(System.lineSeparator()).append("===END===").toString();
    }

    private AbstractMap.SimpleEntry<byte[], Integer> readUpTo1KbOfDataFrom(Socket sourceSocket, byte[] buffer) throws IOException {
        int available = sourceSocket.getInputStream().available();
        int offset = 0;
        while (available > 0) {
            if (available > buffer.length - offset) {
                available = buffer.length - offset;
                sourceSocket.getInputStream().read(buffer, offset, available);
                offset += available;
                break;
            }
            sourceSocket.getInputStream().read(buffer, offset, available);
            offset += available;
            available = sourceSocket.getInputStream().available();
        }
        return new AbstractMap.SimpleEntry<byte[], Integer>(buffer, offset);
    }

    private InetAddress getRemoteIp(Socket socket) {
        return ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
    }

    private class ClientInfo {
        public AtomicInteger count = new AtomicInteger();
        public volatile long lastUse = System.currentTimeMillis();

        public int get() {
            return this.count.get();
        }

        public void decrementAndGet() {
            this.count.decrementAndGet();
            this.lastUse = System.currentTimeMillis();
        }

        public boolean compareAndSet(int expected, int update) {
            boolean b = this.count.compareAndSet(expected, update);
            this.lastUse = System.currentTimeMillis();
            return b;
        }
    }
}

