/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.model.IPortChangeListener;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.HttpEndpointListener;
import com.predic8.membrane.core.transport.http.HttpServerThreadFactory;
import com.predic8.membrane.core.transport.http.IpPort;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="transport")
public class HttpTransport
extends Transport {
    private static Logger log = LoggerFactory.getLogger((String)HttpTransport.class.getName());
    public static final String SOURCE_HOSTNAME = "com.predic8.membrane.transport.http.source.Hostname";
    public static final String HEADER_HOST = "com.predic8.membrane.transport.http.header.Host";
    public static final String SOURCE_IP = "com.predic8.membrane.transport.http.source.Ip";
    private int socketTimeout = 30000;
    private int forceSocketCloseOnHotDeployAfter = 30000;
    private boolean tcpNoDelay = true;
    public Hashtable<IpPort, HttpEndpointListener> portListenerMapping = new Hashtable();
    public List<WeakReference<HttpEndpointListener>> stillRunning = new ArrayList<WeakReference<HttpEndpointListener>>();
    private ThreadPoolExecutor executorService = new ThreadPoolExecutor(20, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new HttpServerThreadFactory());

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
    }

    public boolean isAnyThreadListeningAt(String ip, int port) {
        return this.portListenerMapping.get(new IpPort(ip, port)) != null;
    }

    public Enumeration<IpPort> getAllPorts() {
        return this.portListenerMapping.keys();
    }

    public synchronized void closePort(String ip, int port) throws IOException {
        IpPort p = new IpPort(ip, port);
        log.debug("Closing server port: " + p);
        HttpEndpointListener plt = this.portListenerMapping.get(p);
        if (plt == null) {
            return;
        }
        plt.closePort();
        try {
            plt.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.portListenerMapping.remove(p);
        this.stillRunning.add(new WeakReference<HttpEndpointListener>(plt));
        for (IPortChangeListener listener : this.menuListeners) {
            listener.removePort(port);
        }
    }

    @Override
    public synchronized void closeAll(boolean waitForCompletion) throws IOException {
        log.debug("Closing all network server sockets.");
        Enumeration<IpPort> enumeration = this.getAllPorts();
        while (enumeration.hasMoreElements()) {
            IpPort p = enumeration.nextElement();
            this.closePort(p.ip, p.port);
        }
        log.debug("Closing all stream pumps.");
        this.getRouter().getStatistics().getStreamPumpStats().closeAllStreamPumps();
        if (waitForCompletion) {
            long now = System.currentTimeMillis();
            log.debug("Waiting for running exchanges to finish.");
            this.executorService.shutdown();
            try {
                while (true) {
                    boolean onlyIdle = System.currentTimeMillis() - now <= (long)this.forceSocketCloseOnHotDeployAfter;
                    this.closeConnections(onlyIdle);
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.warn("Still waiting for running exchanges to finish. (Set <transport forceSocketCloseOnHotDeployAfter=\"" + this.forceSocketCloseOnHotDeployAfter + "\"> to a lower value to forcibly close connections more quickly.");
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeConnections(boolean onlyIdle) throws IOException {
        ArrayList<WeakReference<HttpEndpointListener>> remove = new ArrayList<WeakReference<HttpEndpointListener>>();
        for (WeakReference<HttpEndpointListener> whel : this.stillRunning) {
            HttpEndpointListener hel = (HttpEndpointListener)whel.get();
            if (hel == null) {
                remove.add(whel);
                continue;
            }
            if (!hel.closeConnections(onlyIdle)) continue;
            remove.add(whel);
        }
        for (WeakReference<HttpEndpointListener> whel : remove) {
            this.stillRunning.remove(whel);
        }
    }

    @Override
    public synchronized void openPort(String ip, int port, SSLProvider sslProvider) throws IOException {
        if (this.isAnyThreadListeningAt(ip, port)) {
            return;
        }
        if (port == -1) {
            throw new RuntimeException("The port-attribute is missing (probably on a <serviceProxy> element).");
        }
        HttpEndpointListener portListenerThread = new HttpEndpointListener(ip, port, this, sslProvider);
        this.portListenerMapping.put(new IpPort(ip, port), portListenerThread);
        portListenerThread.start();
        for (IPortChangeListener listener : this.menuListeners) {
            listener.addPort(port);
        }
    }

    @Override
    public String getOpenBackendConnections(int port) {
        for (IpPort ipPort : this.portListenerMapping.keySet()) {
            if (ipPort.port != port) continue;
            return Integer.toString(this.portListenerMapping.get(ipPort).getNumberOfOpenConnections());
        }
        return "N/A";
    }

    public int getCoreThreadPoolSize() {
        return this.executorService.getCorePoolSize();
    }

    @MCAttribute
    public void setCoreThreadPoolSize(int corePoolSize) {
        this.executorService.setCorePoolSize(corePoolSize);
    }

    public int getMaxThreadPoolSize() {
        return this.executorService.getMaximumPoolSize();
    }

    @MCAttribute
    public void setMaxThreadPoolSize(int value) {
        this.executorService.setMaximumPoolSize(value);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @MCAttribute
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @MCAttribute
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Override
    public boolean isOpeningPorts() {
        return true;
    }

    public int getForceSocketCloseOnHotDeployAfter() {
        return this.forceSocketCloseOnHotDeployAfter;
    }

    @MCAttribute
    public void setForceSocketCloseOnHotDeployAfter(int forceSocketCloseOnHotDeployAfter) {
        this.forceSocketCloseOnHotDeployAfter = forceSocketCloseOnHotDeployAfter;
    }
}

