/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ClassFinder {
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";

    public static List<Class<?>> find(ClassLoader loader, String scannedPackage) throws IOException, ClassNotFoundException {
        String scannedPath = scannedPackage.replace('.', '/');
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(loader);
        Resource[] resources = resolver.getResources("classpath:" + scannedPath + "/*");
        ArrayList classes = new ArrayList();
        for (Resource resource : resources) {
            String filename = resource.getFilename();
            Class<?> clazz = ClassFinder.getClasses((ResourcePatternResolver)resolver, scannedPackage, filename);
            if (clazz == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static Class<?> getClasses(ResourcePatternResolver resolver, String scannedPackage, String s) throws ClassNotFoundException {
        if (s == null || s.isEmpty() || s.contains("$") || !s.contains(CLASS_FILE_SUFFIX)) {
            return null;
        }
        s = scannedPackage + "." + s.replaceFirst(Pattern.quote(CLASS_FILE_SUFFIX), "");
        return resolver.getClassLoader().loadClass(s);
    }
}

