/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

public class DNSCache {
    private Map<InetAddress, String> hostNames = new Hashtable<InetAddress, String>();
    private Map<InetAddress, String> canonicalHostNames = new Hashtable<InetAddress, String>();
    private Map<InetAddress, String> hostAddresses = new Hashtable<InetAddress, String>();

    public String getHostName(InetAddress address) {
        if (this.hostNames.containsKey(address)) {
            return this.hostNames.get(address);
        }
        String hostName = address.getHostName();
        this.hostNames.put(address, hostName);
        return hostName;
    }

    public String getCanonicalHostName(InetAddress address) {
        if (this.canonicalHostNames.containsKey(address)) {
            return this.canonicalHostNames.get(address);
        }
        String canonicalHostName = address.getCanonicalHostName();
        this.canonicalHostNames.put(address, canonicalHostName);
        return canonicalHostName;
    }

    public String getHostAddress(InetAddress address) {
        if (this.hostAddresses.containsKey(address)) {
            return this.hostAddresses.get(address);
        }
        String hostAddress = address.getHostAddress();
        this.hostAddresses.put(address, hostAddress);
        return hostAddress;
    }

    public Collection<String> getCachedHostNames() {
        return this.hostNames.values();
    }

    public Collection<String> getCachedCanonicalHostNames() {
        return this.canonicalHostNames.values();
    }

    public Collection<String> getCachedHostAddresses() {
        return this.hostAddresses.values();
    }
}

