/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cloud.etcd;

import com.google.common.collect.Lists;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.resolver.SchemaResolver;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;

@MCElement(name="etcdResolver")
public class EtcdResolver
implements SchemaResolver {
    private String url;
    HashSet<Thread> etcdWatchThreads = new HashSet();

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public List<String> getSchemas() {
        return Lists.newArrayList((Object[])new String[]{"etcd"});
    }

    @Override
    public InputStream resolve(String url) throws ResourceRetrievalException {
        String normalizedUrl = this.normalize(url);
        if (normalizedUrl.startsWith("etcd://")) {
            normalizedUrl = normalizedUrl.substring(6);
        }
        int lastSlash = normalizedUrl.lastIndexOf("/");
        String baseKey = normalizedUrl.substring(0, lastSlash);
        String valueName = normalizedUrl.substring(lastSlash + 1, normalizedUrl.length());
        EtcdResponse respGetValue = EtcdRequest.create(this.url, baseKey, "").getValue(valueName).sendRequest();
        if (!respGetValue.is2XX()) {
            throw new ResourceRetrievalException(url);
        }
        String value = respGetValue.getValue();
        return new ByteArrayInputStream(value.getBytes());
    }

    private String normalize(String url) {
        return url.replaceAll(Matcher.quoteReplacement("\\"), "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observeChange(final String url, final Consumer<InputStream> consumer) throws ResourceRetrievalException {
        Thread etcdWatcher = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String normalizedUrl = EtcdResolver.this.normalize(url);
                if (normalizedUrl.startsWith("etcd://")) {
                    normalizedUrl = normalizedUrl.substring(6);
                }
                int lastSlash = normalizedUrl.lastIndexOf("/");
                String baseKey = normalizedUrl.substring(0, lastSlash);
                String valueName = normalizedUrl.substring(lastSlash + 1, normalizedUrl.length());
                EtcdResponse respLongPollForChange = EtcdRequest.create(EtcdResolver.this.url, baseKey, "").getValue(valueName).longPoll().sendRequest();
                if (!respLongPollForChange.is2XX()) {
                    // empty if block
                }
                try {
                    consumer.call(EtcdResolver.this.resolve(normalizedUrl));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashSet<Thread> hashSet = EtcdResolver.this.etcdWatchThreads;
                synchronized (hashSet) {
                    EtcdResolver.this.etcdWatchThreads.remove(Thread.currentThread());
                }
            }
        });
        HashSet<Thread> hashSet = this.etcdWatchThreads;
        synchronized (hashSet) {
            this.etcdWatchThreads.add(etcdWatcher);
        }
        etcdWatcher.start();
    }

    @Override
    public List<String> getChildren(String url) throws FileNotFoundException {
        return null;
    }

    @Override
    public long getTimestamp(String url) throws FileNotFoundException {
        return 0L;
    }
}

