/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.accessors.ExchangeAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ExchangeComparator
implements Comparator<AbstractExchange> {
    private List<ExchangeAccessor> accessors = new ArrayList<ExchangeAccessor>();
    private boolean ascending = true;

    @Override
    public int compare(AbstractExchange e1, AbstractExchange e2) {
        if (e1.getResponse() == null || e2.getResponse() == null) {
            return 0;
        }
        for (ExchangeAccessor accessor : this.accessors) {
            Comparable comp2;
            Comparable comp1 = (Comparable)accessor.get(e1);
            int result = comp1.compareTo(comp2 = (Comparable)accessor.get(e2));
            if (result == 0) continue;
            if (this.ascending) {
                return comp1.compareTo(comp2);
            }
            return comp2.compareTo(comp1);
        }
        return 0;
    }

    public void addAccessor(ExchangeAccessor acc) {
        if (acc == null) {
            return;
        }
        this.accessors.add(acc);
    }

    public void addAccessors(ExchangeAccessor[] excAccessors) {
        if (excAccessors == null || excAccessors.length == 0) {
            return;
        }
        for (ExchangeAccessor accessor : excAccessors) {
            if (accessor == null) continue;
            this.accessors.add(accessor);
        }
    }

    public void removeAccessor(ExchangeAccessor acc) {
        if (acc == null) {
            return;
        }
        this.accessors.remove(acc);
    }

    public void removeAllAccessors() {
        this.accessors.clear();
    }

    public boolean isEmpty() {
        return this.accessors.isEmpty();
    }

    public List<ExchangeAccessor> getAccessors() {
        return this.accessors;
    }

    public void setAccessors(List<ExchangeAccessor> accessors) {
        this.accessors = accessors;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "NONE";
        }
        if (this.accessors.size() == 1) {
            return this.accessors.get(0).getId();
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.accessors.size() - 1; ++i) {
            buffer.append(this.accessors.get(i).getId() + " and ");
        }
        buffer.append(this.accessors.get(this.accessors.size() - 1).getId());
        return buffer.toString();
    }
}

